/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency.decay;

import org.streaminer.stream.frequency.decay.DecayFormula;

public class LogDecayFormula
implements DecayFormula {
    private Double lifeTime;

    public LogDecayFormula(long lifeTimeInSeconds) {
        this.lifeTime = Double.valueOf(lifeTimeInSeconds) * 1000.0;
    }

    public Double evaluate(Double value, Double t) {
        if (t < 0.0 || t >= this.lifeTime) {
            return 0.0;
        }
        return value + 1.0 - Math.pow(Math.E, Math.log(value + 1.0) / this.lifeTime * t);
    }
}

