/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency.decay;

import org.streaminer.stream.frequency.decay.DecayFormula;

public class Quantity {
    private Double quantity;
    private Long timestamp;
    private DecayFormula formula;

    public Quantity(Number quantity, Long timestamp, DecayFormula formula) {
        this.quantity = quantity.doubleValue();
        this.timestamp = timestamp;
        this.formula = formula;
    }

    public Quantity(Number quantity, DecayFormula formula) {
        this(quantity, System.currentTimeMillis(), formula);
    }

    public Quantity(Number quantity, Long timestamp) {
        this(quantity, timestamp, null);
    }

    public Quantity(Number quantity) {
        this(quantity, System.currentTimeMillis());
    }

    public void attachFormula(DecayFormula formula) {
        this.formula = formula;
    }

    public final void add(Quantity a) {
        if (this.timestamp < a.timestamp) {
            this.quantity = this.projectValue(a.timestamp) + a.quantity;
            this.timestamp = a.timestamp;
        } else {
            this.quantity = this.quantity + a.projectValue(this.timestamp);
        }
    }

    public final Double valueNow() {
        return this.projectValue(System.currentTimeMillis());
    }

    public String toString() {
        return String.valueOf(this.valueNow() + ":" + this.timestamp);
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Double projectValue(Long futureTimestamp) {
        if (futureTimestamp < this.timestamp) {
            throw new IllegalArgumentException("Cannot project decaying quantity into the past.");
        }
        Double t = futureTimestamp - this.timestamp;
        return this.formula.evaluate(this.quantity, t);
    }
}

