/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency.topk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.streaminer.stream.frequency.topk.ITopK;
import org.streaminer.stream.frequency.util.CountEntry;
import org.streaminer.stream.frequency.util.ScoredItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentStreamSummary<T>
implements ITopK<T> {
    private final int capacity;
    private final ConcurrentHashMap<T, ScoredItem> itemMap;
    private final AtomicReference<ScoredItem> minVal;
    private final AtomicLong size;
    private final AtomicBoolean reachCapacity;

    public ConcurrentStreamSummary(int capacity) {
        this.capacity = capacity;
        this.minVal = new AtomicReference();
        this.size = new AtomicLong(0L);
        this.itemMap = new ConcurrentHashMap(capacity);
        this.reachCapacity = new AtomicBoolean(false);
    }

    @Override
    public boolean add(T element) {
        return this.add(element, 1L);
    }

    @Override
    public boolean add(T element, long incrementCount) {
        long val = incrementCount;
        ScoredItem<T> value = new ScoredItem<T>(element, incrementCount);
        ScoredItem<T> oldVal = this.itemMap.putIfAbsent(element, value);
        if (oldVal != null) {
            val = oldVal.addAndGetCount(incrementCount);
        } else if (this.reachCapacity.get() || this.size.incrementAndGet() > (long)this.capacity) {
            this.reachCapacity.set(true);
            ScoredItem<T> oldMinVal = this.minVal.getAndSet(value);
            this.itemMap.remove(oldMinVal.getItem());
            while (oldMinVal.isNewItem()) {
            }
            long count = oldMinVal.getCount();
            value.addAndGetCount(count);
            value.setError(count);
        }
        value.setNewItem(false);
        this.minVal.set(this.getMinValue());
        return val != incrementCount;
    }

    private ScoredItem getMinValue() {
        ScoredItem minVal = null;
        for (ScoredItem entry : this.itemMap.values()) {
            if (minVal != null && (entry.isNewItem() || entry.getCount() >= minVal.getCount())) continue;
            minVal = entry;
        }
        return minVal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (ScoredItem entry : this.itemMap.values()) {
            sb.append("(" + entry.getCount() + ": " + entry.getItem() + ", e: " + entry.getError() + "),");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public List<CountEntry<T>> peek(int k) {
        ArrayList<CountEntry<T>> toReturn = new ArrayList<CountEntry<T>>(k);
        List<ScoredItem<T>> values = this.peekWithScores(k);
        for (ScoredItem<T> value : values) {
            toReturn.add(new CountEntry<T>(value.getItem(), value.getCount()));
        }
        Collections.sort(toReturn);
        return toReturn;
    }

    @Override
    public long size() {
        return this.size.get();
    }

    public List<ScoredItem<T>> peekWithScores(int k) {
        ArrayList<ScoredItem<T>> values = new ArrayList<ScoredItem<T>>();
        for (Map.Entry<T, ScoredItem> entry : this.itemMap.entrySet()) {
            ScoredItem value = entry.getValue();
            values.add(new ScoredItem(value.getItem(), value.getCount(), value.getError()));
        }
        Collections.sort(values);
        values = values.size() > k ? values.subList(0, k) : values;
        return values;
    }
}

