/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency.topk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.streaminer.stream.frequency.FrequencyException;
import org.streaminer.stream.frequency.topk.ITopK;
import org.streaminer.stream.frequency.util.CountEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frequent<T>
implements ITopK<T> {
    private long elementsCounted = 0L;
    private boolean over = false;
    private int k;
    private final Map<T, AtomicLong> dataStructure;

    public Frequent(double error) {
        this.k = (int)Math.ceil(1.0 / error);
        this.dataStructure = new HashMap<T, AtomicLong>(this.k - 1);
    }

    @Override
    public boolean add(T item) throws FrequencyException {
        return this.add(item, 1L);
    }

    @Override
    public boolean add(T item, long incrementCount) throws FrequencyException {
        if (this.elementsCounted == Long.MAX_VALUE) {
            throw new FrequencyException("Overflowed 9223372036854775807");
        }
        ++this.elementsCounted;
        AtomicLong counter = this.dataStructure.get(item);
        if (counter != null) {
            counter.addAndGet(incrementCount);
            return false;
        }
        if (this.dataStructure.size() < this.k) {
            this.dataStructure.put(item, new AtomicLong(incrementCount));
        } else {
            ArrayList<T> toRemove = new ArrayList<T>();
            for (Map.Entry<T, AtomicLong> entry : this.dataStructure.entrySet()) {
                long newValue = entry.getValue().decrementAndGet();
                if (newValue != 0L) continue;
                toRemove.add(entry.getKey());
            }
            if (toRemove.size() > 0) {
                for (Map.Entry<Object, AtomicLong> t : toRemove) {
                    this.dataStructure.remove(t);
                }
            }
        }
        return true;
    }

    @Override
    public List<CountEntry<T>> peek(int k) {
        ArrayList<CountEntry<T>> list = new ArrayList<CountEntry<T>>();
        for (Map.Entry<T, AtomicLong> entry : this.dataStructure.entrySet()) {
            list.add(new CountEntry<T>(entry.getKey(), entry.getValue().get()));
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public long size() {
        return this.elementsCounted;
    }
}

