/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency.topk;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.streaminer.stream.frequency.topk.ITopK;
import org.streaminer.stream.frequency.util.CountEntry;
import org.streaminer.stream.frequency.util.ISampleSet;
import org.streaminer.stream.frequency.util.SampleSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StochasticTopper<T>
implements ITopK<T> {
    private int sampleSize;
    private ISampleSet<T> sample;
    private Random random;
    private long count;

    public StochasticTopper(int sampleSize) {
        this(sampleSize, null);
    }

    public StochasticTopper(int sampleSize, Long seed) {
        this.sample = new SampleSet(sampleSize);
        this.sampleSize = sampleSize;
        this.random = seed != null ? new Random(seed) : new Random();
    }

    @Override
    public boolean add(T element, long incrementCount) {
        ++this.count;
        boolean taken = false;
        if (this.sample.count() < (long)this.sampleSize) {
            this.sample.put(element, incrementCount);
            taken = true;
        } else if (this.random.nextDouble() < (double)this.sampleSize / (double)this.count) {
            this.sample.removeRandom();
            this.sample.put(element, incrementCount);
            taken = true;
        }
        return taken;
    }

    @Override
    public boolean add(T item) {
        return this.add(item, 1L);
    }

    @Override
    public List<CountEntry<T>> peek(int k) {
        List<CountEntry<T>> result = this.sample.peek(k);
        Collections.sort(result);
        return result;
    }

    @Override
    public long size() {
        return this.sampleSize;
    }
}

