/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency.topk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.streaminer.stream.frequency.topk.ITopK;
import org.streaminer.stream.frequency.util.CountEntry;
import org.streaminer.stream.frequency.util.Counter;
import org.streaminer.util.DoublyLinkedList;
import org.streaminer.util.ListNode2;
import org.streaminer.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamSummary<T>
implements ITopK<T> {
    protected int capacity;
    private HashMap<T, ListNode2<Counter<T>>> counterMap;
    protected DoublyLinkedList<Bucket> bucketList;

    public StreamSummary() {
    }

    public StreamSummary(int capacity) {
        this.capacity = capacity;
        this.counterMap = new HashMap();
        this.bucketList = new DoublyLinkedList();
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean add(T item) {
        return this.add(item, 1L);
    }

    @Override
    public boolean add(T element, long incrementCount) {
        return (Boolean)this.offerReturnAll(element, (long)incrementCount).left;
    }

    public T offerReturnDropped(T item, int incrementCount) {
        return (T)this.offerReturnAll(item, (long)((long)incrementCount)).right;
    }

    public Pair<Boolean, T> offerReturnAll(T item, long incrementCount) {
        ListNode2<Counter<T>> counterNode = this.counterMap.get(item);
        boolean isNewItem = counterNode == null;
        Object droppedItem = null;
        if (isNewItem) {
            if (this.size() < (long)this.capacity) {
                counterNode = this.bucketList.enqueue((Bucket)(StreamSummary)this.new Bucket((long)0L)).getValue().counterList.add(new Counter<T>(this.bucketList.tail(), item));
            } else {
                Bucket min = this.bucketList.first();
                counterNode = min.counterList.tail();
                Counter<T> counter = counterNode.getValue();
                droppedItem = counter.getItem();
                this.counterMap.remove(droppedItem);
                counter.setItem(item);
                counter.setError(min.count);
            }
            this.counterMap.put(item, counterNode);
        }
        this.incrementCounter(counterNode, incrementCount);
        return new Pair<Boolean, Object>(isNewItem, droppedItem);
    }

    protected void incrementCounter(ListNode2<Counter<T>> counterNode, long incrementCount) {
        Bucket bucketNext;
        Counter<T> counter = counterNode.getValue();
        ListNode2<Bucket> oldNode = counter.getBucketNode();
        Bucket bucket = oldNode.getValue();
        bucket.counterList.remove(counterNode);
        counter.incrementCount(incrementCount);
        ListNode2<Bucket> bucketNodePrev = oldNode;
        ListNode2<Bucket> bucketNodeNext = bucketNodePrev.getNext();
        while (bucketNodeNext != null) {
            bucketNext = bucketNodeNext.getValue();
            if (counter.getCount() == bucketNext.count) {
                bucketNext.counterList.add(counterNode);
                break;
            }
            if (counter.getCount() > bucketNext.count) {
                bucketNodePrev = bucketNodeNext;
                bucketNodeNext = bucketNodePrev.getNext();
                continue;
            }
            bucketNodeNext = null;
        }
        if (bucketNodeNext == null) {
            bucketNext = new Bucket(counter.getCount());
            bucketNext.counterList.add(counterNode);
            bucketNodeNext = this.bucketList.addAfter(bucketNodePrev, bucketNext);
        }
        counter.setBucketNode(bucketNodeNext);
        if (bucket.counterList.isEmpty()) {
            this.bucketList.remove(oldNode);
        }
    }

    @Override
    public List<CountEntry<T>> peek(int k) {
        ArrayList<CountEntry<T>> list = new ArrayList<CountEntry<T>>(k);
        for (ListNode2<Bucket> bNode = this.bucketList.head(); bNode != null; bNode = bNode.getPrev()) {
            Bucket b = bNode.getValue();
            for (Counter c : b.counterList) {
                if (list.size() == k) {
                    Collections.sort(list);
                    return list;
                }
                list.add(new CountEntry(c.getItem(), c.getCount()));
            }
        }
        Collections.sort(list);
        return list;
    }

    public List<Counter<T>> topK(int k) {
        ArrayList<Counter<T>> topK = new ArrayList<Counter<T>>(k);
        for (ListNode2<Bucket> bNode = this.bucketList.head(); bNode != null; bNode = bNode.getPrev()) {
            Bucket b = bNode.getValue();
            for (Counter c : b.counterList) {
                if (topK.size() == k) {
                    return topK;
                }
                topK.add(c);
            }
        }
        return topK;
    }

    @Override
    public long size() {
        return this.counterMap.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (ListNode2<Bucket> bNode = this.bucketList.head(); bNode != null; bNode = bNode.getPrev()) {
            Bucket b = bNode.getValue();
            sb.append('{');
            sb.append(b.count);
            sb.append(":[");
            for (Counter c : b.counterList) {
                sb.append('{');
                sb.append(c.getItem());
                sb.append(':');
                sb.append(c.getError());
                sb.append("},");
            }
            if (b.counterList.size() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("]},");
        }
        if (this.bucketList.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(']');
        return sb.toString();
    }

    public class Bucket {
        protected DoublyLinkedList<Counter<T>> counterList;
        private long count;

        public Bucket(long count) {
            this.count = count;
            this.counterList = new DoublyLinkedList();
        }
    }
}

