/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.frequency.util;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountEntry<T>
implements Serializable,
Cloneable,
Comparable<CountEntry> {
    private static final transient Logger LOG = LoggerFactory.getLogger(CountEntry.class);
    private static final long serialVersionUID = 1L;
    public T item;
    public long frequency;

    public CountEntry(T item, long frequency) {
        this.item = item;
        this.frequency = frequency;
    }

    public CountEntry(T item) {
        this(item, 0L);
    }

    public T getItem() {
        return this.item;
    }

    public void setItem(T item) {
        this.item = item;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
    }

    public String toString() {
        return "CountEntry[item=" + this.item + ", freq=" + this.frequency + "]";
    }

    public CountEntry<T> clone() throws CloneNotSupportedException {
        try {
            CountEntry clone = (CountEntry)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public int compareTo(CountEntry o) {
        long y;
        long x = o.getFrequency();
        return x < (y = this.frequency) ? -1 : (x == y ? 0 : 1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CountEntry)) {
            return false;
        }
        CountEntry other = (CountEntry)obj;
        return this.item.equals(other.item);
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.item != null ? this.item.hashCode() : 0);
        return hash;
    }
}

