/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.histogram.spdt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.streaminer.stream.histogram.spdt.Bin;
import org.streaminer.stream.histogram.spdt.BinReservoir;
import org.streaminer.stream.histogram.spdt.Target;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayBinReservoir<T extends Target>
extends BinReservoir<T> {
    private ArrayList<Bin<T>> _bins = new ArrayList();

    public ArrayBinReservoir(int maxBins, boolean weightGaps, Long freezeThreshold) {
        super(maxBins, weightGaps, freezeThreshold);
    }

    @Override
    public void insert(Bin<T> bin) {
        this.addTotalCount(bin);
        int index = Collections.binarySearch(this._bins, bin);
        if (index >= 0) {
            this._bins.get(index).sumUpdate(bin);
        } else if (this.isFrozen()) {
            double nextDist;
            int prevIndex = Math.abs(index) - 2;
            int nextIndex = prevIndex + 1;
            double prevDist = prevIndex >= 0 ? bin.getMean() - this._bins.get(prevIndex).getMean() : Double.MAX_VALUE;
            double d = nextDist = nextIndex < this._bins.size() ? this._bins.get(nextIndex).getMean() - bin.getMean() : Double.MAX_VALUE;
            if (prevDist < nextDist) {
                this._bins.get(prevIndex).sumUpdate(bin);
            } else {
                this._bins.get(nextIndex).sumUpdate(bin);
            }
        } else {
            this._bins.add(Math.abs(index) - 1, bin);
        }
    }

    @Override
    public Bin<T> first() {
        return this._bins.get(0);
    }

    @Override
    public Bin<T> last() {
        return this._bins.get(this._bins.size() - 1);
    }

    @Override
    public Bin<T> get(double p) {
        int index = Collections.binarySearch(this._bins, new Bin<Object>(p, 0.0, null));
        return index >= 0 ? this._bins.get(index) : null;
    }

    @Override
    public Bin<T> floor(double p) {
        int index = Collections.binarySearch(this._bins, new Bin<Object>(p, 0.0, null));
        if (index >= 0) {
            return this._bins.get(index);
        }
        return (index = Math.abs(index) - 2) >= 0 ? this._bins.get(index) : null;
    }

    @Override
    public Bin<T> ceiling(double p) {
        int index = Collections.binarySearch(this._bins, new Bin<Object>(p, 0.0, null));
        if (index >= 0) {
            return this._bins.get(index);
        }
        return (index = Math.abs(index) - 1) < this._bins.size() ? this._bins.get(index) : null;
    }

    @Override
    public Bin<T> lower(double p) {
        int index = Collections.binarySearch(this._bins, new Bin<Object>(p, 0.0, null));
        index = index >= 0 ? --index : Math.abs(index) - 2;
        return index >= 0 ? this._bins.get(index) : null;
    }

    @Override
    public Bin<T> higher(double p) {
        int index = Collections.binarySearch(this._bins, new Bin<Object>(p, 0.0, null));
        index = index >= 0 ? ++index : Math.abs(index) - 1;
        return index < this._bins.size() ? this._bins.get(index) : null;
    }

    @Override
    public Collection<Bin<T>> getBins() {
        return this._bins;
    }

    @Override
    public void merge() {
        while (this._bins.size() > this.getMaxBins()) {
            int minGapIndex = -1;
            double minGap = Double.MAX_VALUE;
            for (int i = 0; i < this._bins.size() - 1; ++i) {
                double gap = this.gapWeight(this._bins.get(i), this._bins.get(i + 1));
                if (!(minGap > gap)) continue;
                minGap = gap;
                minGapIndex = i;
            }
            Bin<T> prev = this._bins.get(minGapIndex);
            Bin<T> next = this._bins.remove(minGapIndex + 1);
            this._bins.set(minGapIndex, prev.combine(next));
        }
    }
}

