/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.histogram.spdt;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.streaminer.stream.histogram.spdt.CategoricalTarget;
import org.streaminer.stream.histogram.spdt.Histogram;
import org.streaminer.stream.histogram.spdt.MixedInsertException;
import org.streaminer.stream.histogram.spdt.Target;
import org.streaminer.util.math.NumberUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayCategoricalTarget
extends Target<ArrayCategoricalTarget>
implements CategoricalTarget {
    private Map<Object, Integer> _indexMap;
    private double[] _target;
    private double _missingCount;

    public ArrayCategoricalTarget(Map<Object, Integer> indexMap, double missingCount) {
        this._indexMap = indexMap;
        this._target = new double[indexMap.size()];
        Arrays.fill(this._target, 0.0);
        this._missingCount = missingCount;
    }

    public ArrayCategoricalTarget(Map<Object, Integer> indexMap, Object category) throws MixedInsertException {
        this(indexMap, category == null ? 1.0 : 0.0);
        if (category != null) {
            Integer index = indexMap.get(category);
            if (index == null) {
                throw new MixedInsertException();
            }
            int n = index;
            this._target[n] = this._target[n] + 1.0;
        }
    }

    public void setIndexMap(Map<Object, Integer> indexMap) {
        this._indexMap = indexMap;
    }

    public HashMap<Object, Double> getCounts() {
        HashMap<Object, Double> countMap = new HashMap<Object, Double>();
        for (Map.Entry<Object, Integer> entry : this._indexMap.entrySet()) {
            Object category = entry.getKey();
            Integer index = entry.getValue();
            countMap.put(category, this._target[index]);
        }
        return countMap;
    }

    @Override
    public double getMissingCount() {
        return this._missingCount;
    }

    @Override
    public Histogram.TargetType getTargetType() {
        return Histogram.TargetType.categorical;
    }

    @Override
    protected void addJSON(JSONArray binJSON, DecimalFormat format) {
        JSONObject counts = new JSONObject();
        for (Map.Entry<Object, Integer> categoryIndex : this._indexMap.entrySet()) {
            Object category = categoryIndex.getKey();
            int index = categoryIndex.getValue();
            double count = this._target[index];
            counts.put(category, (Object)NumberUtil.roundNumber(count, format));
        }
        binJSON.add((Object)counts);
    }

    @Override
    protected ArrayCategoricalTarget sum(ArrayCategoricalTarget target) {
        for (int i = 0; i < this._target.length; ++i) {
            int n = i;
            this._target[n] = this._target[n] + target._target[i];
        }
        this._missingCount += target.getMissingCount();
        return this;
    }

    @Override
    protected ArrayCategoricalTarget mult(double multiplier) {
        int i = 0;
        while (i < this._target.length) {
            int n = i++;
            this._target[n] = this._target[n] * multiplier;
        }
        this._missingCount *= multiplier;
        return this;
    }

    @Override
    protected ArrayCategoricalTarget clone() {
        ArrayCategoricalTarget rct = new ArrayCategoricalTarget(this._indexMap, this._missingCount);
        rct._target = (double[])this._target.clone();
        return rct;
    }

    @Override
    protected ArrayCategoricalTarget init() {
        return new ArrayCategoricalTarget(this._indexMap, 0.0);
    }
}

