/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.histogram.spdt;

import java.text.DecimalFormat;
import org.json.simple.JSONArray;
import org.streaminer.stream.histogram.spdt.BinUpdateException;
import org.streaminer.stream.histogram.spdt.Target;
import org.streaminer.util.math.NumberUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bin<T extends Target>
implements Comparable<Bin> {
    private T _target;
    private final double _mean;
    private double _count;

    public Bin(double mean, double count, T target) {
        this._mean = mean == 0.0 ? 0.0 : mean;
        this._count = count;
        this._target = target;
    }

    public Bin(Bin<T> bin) {
        this(bin.getMean(), bin.getCount(), ((Target)bin.getTarget()).clone());
    }

    public JSONArray toJSON(DecimalFormat format) {
        JSONArray binJSON = new JSONArray();
        binJSON.add((Object)NumberUtil.roundNumber(this._mean, format));
        binJSON.add((Object)NumberUtil.roundNumber(this._count, format));
        ((Target)this._target).addJSON(binJSON, format);
        return binJSON;
    }

    public double getCount() {
        return this._count;
    }

    public double getMean() {
        return this._mean;
    }

    public double getWeight() {
        return this._mean * this._count;
    }

    public T getTarget() {
        return this._target;
    }

    public void sumUpdate(Bin bin) {
        this._count += bin.getCount();
        ((Target)this._target).sum(bin.getTarget());
    }

    public void update(Bin bin) throws BinUpdateException {
        if (this._mean != bin.getMean()) {
            throw new BinUpdateException("Bins must have matching means to update");
        }
        this._count = bin.getCount();
        this._target = bin.getTarget();
    }

    public String toString() {
        return this.toJSON(new DecimalFormat("#.#####")).toJSONString();
    }

    public Bin combine(Bin<T> bin) {
        double count = this.getCount() + bin.getCount();
        double mean = (this.getWeight() + bin.getWeight()) / count;
        T newTarget = ((Target)this._target).init();
        ((Target)newTarget).sum(this._target);
        ((Target)newTarget).sum(bin.getTarget());
        return new Bin(mean, count, newTarget);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bin other = (Bin)obj;
        return Double.doubleToLongBits(this._mean) == Double.doubleToLongBits(other._mean);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this._mean) ^ Double.doubleToLongBits(this._mean) >>> 32);
        return hash;
    }

    @Override
    public int compareTo(Bin o) {
        return Double.compare(this.getMean(), o.getMean());
    }
}

