/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.histogram.spdt;

import java.util.Collection;
import org.streaminer.stream.histogram.spdt.Bin;
import org.streaminer.stream.histogram.spdt.Target;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinReservoir<T extends Target> {
    private final int _maxBins;
    private final boolean _weightGaps;
    private final Long _freezeThreshold;
    private long _totalCount;

    public BinReservoir(int maxBins, boolean weightGaps, Long freezeThreshold) {
        this._maxBins = maxBins;
        this._weightGaps = weightGaps;
        this._freezeThreshold = freezeThreshold;
        this._totalCount = 0L;
    }

    public int getMaxBins() {
        return this._maxBins;
    }

    public boolean isWeightGaps() {
        return this._weightGaps;
    }

    public Long getFreezeThreshold() {
        return this._freezeThreshold;
    }

    public boolean isFrozen() {
        return this._freezeThreshold != null && this._totalCount > this._freezeThreshold;
    }

    public long getTotalCount() {
        return this._totalCount;
    }

    public void addTotalCount(Bin<T> bin) {
        this._totalCount = (long)((double)this._totalCount + bin.getCount());
    }

    public abstract void insert(Bin<T> var1);

    public abstract Bin<T> first();

    public abstract Bin<T> last();

    public abstract Bin<T> get(double var1);

    public abstract Bin<T> floor(double var1);

    public abstract Bin<T> ceiling(double var1);

    public abstract Bin<T> higher(double var1);

    public abstract Bin<T> lower(double var1);

    public abstract Collection<Bin<T>> getBins();

    public abstract void merge();

    protected double gapWeight(Bin<T> prev, Bin<T> next) {
        double diff = next.getMean() - prev.getMean();
        if (this.isWeightGaps()) {
            diff *= Math.log(Math.E + Math.min(prev.getCount(), next.getCount()));
        }
        return diff;
    }
}

