/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.histogram.spdt;

import org.json.simple.JSONArray;
import org.streaminer.stream.histogram.spdt.Bin;
import org.streaminer.stream.histogram.spdt.Target;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gap<T extends Target>
implements Comparable<Gap> {
    private final double _weight;
    private final Bin<T> _startBin;
    private final Bin<T> _endBin;

    public Gap(Bin<T> startBin, Bin<T> endBin, double weight) {
        this._startBin = startBin;
        this._endBin = endBin;
        this._weight = weight;
    }

    public Gap(Bin<T> startBin, Bin<T> endBin) {
        this(startBin, endBin, endBin.getMean() - startBin.getMean());
    }

    public Bin<T> getStartBin() {
        return this._startBin;
    }

    public Bin<T> getEndBin() {
        return this._endBin;
    }

    public double getSpace() {
        return this._weight;
    }

    public String toString() {
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)this._weight);
        jsonArray.add(this._startBin);
        jsonArray.add(this._endBin);
        return jsonArray.toJSONString();
    }

    @Override
    public int compareTo(Gap t) {
        int result = Double.compare(this.getSpace(), t.getSpace());
        if (result == 0) {
            result = this.getStartBin().compareTo(t.getStartBin());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Gap other = (Gap)obj;
        if (Double.doubleToLongBits(this._weight) != Double.doubleToLongBits(other._weight)) {
            return false;
        }
        return this._startBin == other._startBin || this._startBin != null && this._startBin.equals(other._startBin);
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (int)(Double.doubleToLongBits(this._weight) ^ Double.doubleToLongBits(this._weight) >>> 32);
        hash = 23 * hash + (this._startBin != null ? this._startBin.hashCode() : 0);
        return hash;
    }
}

