/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.histogram.spdt;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.json.simple.JSONArray;
import org.streaminer.stream.histogram.spdt.Histogram;
import org.streaminer.stream.histogram.spdt.MapCategoricalTarget;
import org.streaminer.stream.histogram.spdt.NumericTarget;
import org.streaminer.stream.histogram.spdt.Target;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupTarget
extends Target<GroupTarget> {
    private ArrayList<Target> _target;

    public GroupTarget(ArrayList<Target> group) {
        this._target = group;
    }

    public GroupTarget(Collection<Object> values, Collection<Histogram.TargetType> types) {
        ArrayList<MapCategoricalTarget> group = new ArrayList<MapCategoricalTarget>();
        if (types == null) {
            for (Object value : values) {
                Target target;
                if (value instanceof Number) {
                    Double tVal = value == null ? null : Double.valueOf(((Number)value).doubleValue());
                    target = new NumericTarget(tVal);
                } else {
                    target = new MapCategoricalTarget(value);
                }
                group.add((MapCategoricalTarget)target);
            }
        } else {
            Iterator<Object> valueIter = values.iterator();
            Iterator<Histogram.TargetType> typeIter = types.iterator();
            while (valueIter.hasNext()) {
                Target target;
                Object value = valueIter.next();
                Histogram.TargetType type = typeIter.next();
                if (type == Histogram.TargetType.numeric) {
                    Double tVal = value == null ? null : Double.valueOf(((Number)value).doubleValue());
                    target = new NumericTarget(tVal);
                } else {
                    target = new MapCategoricalTarget(value);
                }
                group.add((MapCategoricalTarget)target);
            }
        }
        this._target = group;
    }

    public ArrayList<Target> getGroupTarget() {
        return this._target;
    }

    @Override
    public double getMissingCount() {
        return 0.0;
    }

    @Override
    public Histogram.TargetType getTargetType() {
        return Histogram.TargetType.group;
    }

    @Override
    protected void addJSON(JSONArray binJSON, DecimalFormat format) {
        JSONArray targetsJSON = new JSONArray();
        for (Target target : this._target) {
            target.addJSON(targetsJSON, format);
        }
        binJSON.add((Object)targetsJSON);
    }

    @Override
    protected GroupTarget sum(GroupTarget group) {
        for (int i = 0; i < this._target.size(); ++i) {
            this._target.get(i).sum(group.getGroupTarget().get(i));
        }
        return this;
    }

    @Override
    protected GroupTarget mult(double multiplier) {
        for (Target target : this._target) {
            target.mult(multiplier);
        }
        return this;
    }

    @Override
    protected GroupTarget clone() {
        ArrayList<Object> newGroup = new ArrayList<Object>();
        for (Target target : this._target) {
            newGroup.add(target.clone());
        }
        return new GroupTarget(new ArrayList<Target>(newGroup));
    }

    @Override
    protected GroupTarget init() {
        ArrayList newGroup = new ArrayList();
        for (Target target : this._target) {
            newGroup.add(target.init());
        }
        return new GroupTarget(new ArrayList<Target>(newGroup));
    }
}

