/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.histogram.spdt;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.json.simple.JSONArray;
import org.streaminer.stream.histogram.spdt.ArrayBinReservoir;
import org.streaminer.stream.histogram.spdt.ArrayCategoricalTarget;
import org.streaminer.stream.histogram.spdt.Bin;
import org.streaminer.stream.histogram.spdt.BinReservoir;
import org.streaminer.stream.histogram.spdt.GroupTarget;
import org.streaminer.stream.histogram.spdt.MapCategoricalTarget;
import org.streaminer.stream.histogram.spdt.MixedInsertException;
import org.streaminer.stream.histogram.spdt.NumericTarget;
import org.streaminer.stream.histogram.spdt.SimpleTarget;
import org.streaminer.stream.histogram.spdt.SumOutOfRangeException;
import org.streaminer.stream.histogram.spdt.SumResult;
import org.streaminer.stream.histogram.spdt.Target;
import org.streaminer.stream.histogram.spdt.TreeBinReservoir;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Histogram<T extends Target> {
    public static final String DEFAULT_FORMAT_STRING = "#.#####";
    public static final int RESERVOIR_THRESHOLD = 256;
    private TargetType _targetType;
    private final BinReservoir<T> _bins;
    private final DecimalFormat _decimalFormat;
    private ArrayList<TargetType> _groupTypes;
    private HashMap<Object, Integer> _indexMap;
    private long _missingCount;
    private T _missingTarget;
    private Double _minimum;
    private Double _maximum;
    private TreeMap<Double, Bin<T>> _sumToBinMap;
    private TreeMap<Double, SumResult<T>> _pointToSumMap;

    public Histogram(int maxBins, boolean countWeightedGaps, Collection<Object> categories, Collection<TargetType> groupTypes, Long freezeThreshold, BinReservoirType reservoirType) {
        this._bins = reservoirType == BinReservoirType.tree || reservoirType == null && maxBins > 256 ? new TreeBinReservoir(maxBins, countWeightedGaps, freezeThreshold) : new ArrayBinReservoir(maxBins, countWeightedGaps, freezeThreshold);
        this._decimalFormat = new DecimalFormat(DEFAULT_FORMAT_STRING);
        this._missingCount = 0L;
        this._minimum = null;
        this._maximum = null;
        if (categories != null && !categories.isEmpty()) {
            this._targetType = TargetType.categorical;
            this._groupTypes = null;
            this._indexMap = new HashMap();
            for (Object category : categories) {
                if (this._indexMap.get(category) != null) continue;
                this._indexMap.put(category, this._indexMap.size());
            }
        } else if (groupTypes != null && !groupTypes.isEmpty()) {
            this._targetType = TargetType.group;
            this._groupTypes = new ArrayList<TargetType>(groupTypes);
        } else {
            this._groupTypes = null;
            this._indexMap = null;
        }
    }

    public Histogram(int maxBins, boolean countWeightedGaps) {
        this(maxBins, countWeightedGaps, null, null, null, null);
    }

    public Histogram(int maxBins) {
        this(maxBins, false);
    }

    public Histogram<T> insert(Double point) throws MixedInsertException {
        this.checkType(TargetType.none);
        this.processPointTarget(point, SimpleTarget.TARGET);
        return this;
    }

    public Histogram<T> insert(Double point, double target) throws MixedInsertException {
        return this.insertNumeric(point, target);
    }

    public Histogram<T> insert(Double point, String target) throws MixedInsertException {
        return this.insertCategorical(point, target);
    }

    public Histogram<T> insert(Double point, Collection<Object> group) throws MixedInsertException {
        return this.insertGroup(point, group);
    }

    public Histogram<T> insertCategorical(Double point, Object target) throws MixedInsertException {
        this.checkType(TargetType.categorical);
        Target catTarget = this._indexMap == null ? new MapCategoricalTarget(target) : new ArrayCategoricalTarget(this._indexMap, target);
        this.processPointTarget(point, catTarget);
        return this;
    }

    public Histogram<T> insertNumeric(Double point, Double target) throws MixedInsertException {
        this.checkType(TargetType.numeric);
        this.processPointTarget(point, new NumericTarget(target));
        return this;
    }

    public Histogram<T> insertGroup(Double point, Collection<Object> group) throws MixedInsertException {
        this.checkType(TargetType.group);
        if (group == null) {
            throw new MixedInsertException();
        }
        GroupTarget groupTarget = new GroupTarget(group, this._groupTypes);
        if (this._groupTypes == null) {
            this._groupTypes = new ArrayList();
            for (Target t : groupTarget.getGroupTarget()) {
                this._groupTypes.add(t.getTargetType());
            }
        }
        this.processPointTarget(point, groupTarget);
        return this;
    }

    public Histogram<T> insertBin(Bin<T> bin) {
        if (this._minimum == null || this._minimum > bin.getMean()) {
            this._minimum = bin.getMean();
        }
        if (this._maximum == null || this._maximum < bin.getMean()) {
            this._maximum = bin.getMean();
        }
        this.clearCacheMaps();
        this._bins.insert(bin);
        this._bins.merge();
        return this;
    }

    public TargetType getTargetType() {
        return this._targetType;
    }

    public ArrayList<TargetType> getGroupTypes() {
        return this._groupTypes;
    }

    public int getMaxBins() {
        return this._bins.getMaxBins();
    }

    public Long getFreezeThreshold() {
        return this._bins.getFreezeThreshold();
    }

    public boolean isCountWeightedGaps() {
        return this._bins.isWeightGaps();
    }

    public List<Object> getTargetCategories() {
        List<Object> categories = null;
        if (this._indexMap != null) {
            Object[] catArray = new Object[this._indexMap.size()];
            for (Map.Entry<Object, Integer> entry : this._indexMap.entrySet()) {
                catArray[entry.getValue().intValue()] = entry.getKey();
            }
            categories = Arrays.asList(catArray);
        }
        return categories;
    }

    public double sum(double p) throws SumOutOfRangeException {
        return this.extendedSum(p).getCount();
    }

    public SumResult<T> extendedSum(double p) throws SumOutOfRangeException {
        SumResult<Object> result;
        if (this._bins.getBins().isEmpty()) {
            throw new SumOutOfRangeException("Cannot sum with an empty histogram.");
        }
        if (Double.isNaN(p)) {
            throw new SumOutOfRangeException("Cannot compute a histogram sum for NaN");
        }
        double binMax = this._bins.last().getMean();
        if (p < this._minimum) {
            result = new SumResult(0.0, ((Target)this._bins.first().getTarget()).init());
        } else if (p >= this._maximum) {
            result = new SumResult<T>(this.getTotalCount(), this.getTotalTargetSum());
        } else if (p == binMax) {
            Bin<T> lastBin = this._bins.last();
            double totalCount = this.getTotalCount();
            double count = totalCount - lastBin.getCount() / 2.0;
            Object targetSum = ((Target)this.getTotalTargetSum()).sum(((Target)((Target)lastBin.getTarget()).clone()).mult(-0.5));
            result = new SumResult(count, targetSum);
        } else {
            T prevTargetSum;
            double prevCount;
            Bin<Object> bin_i1;
            Object emptyTarget = ((Target)this._bins.first().getTarget()).init();
            Bin<Object> bin_i = this._bins.floor(p);
            if (bin_i == null) {
                bin_i = new Bin<Object>(this._minimum, 0.0, ((Target)emptyTarget).clone());
            }
            if ((bin_i1 = this._bins.higher(p)) == null) {
                bin_i1 = new Bin<Object>(this._maximum, 0.0, ((Target)emptyTarget).clone());
            }
            if (bin_i.getMean() == this._minimum.doubleValue()) {
                prevCount = this._bins.first().getCount() / 2.0;
                prevTargetSum = ((Target)((Target)this._bins.first().getTarget()).clone()).mult(0.5);
            } else {
                SumResult<T> prevSumResult = this.getPointToSumMap().get(bin_i.getMean());
                prevCount = prevSumResult.getCount();
                prevTargetSum = prevSumResult.getTargetSum();
            }
            double bDiff = p - bin_i.getMean();
            double pDiff = bin_i1.getMean() - bin_i.getMean();
            double bpRatio = bDiff / pDiff;
            NumericTarget countTarget = (NumericTarget)this.computeSum(bpRatio, new NumericTarget(prevCount), new NumericTarget(bin_i.getCount()), new NumericTarget(bin_i1.getCount()));
            double countSum = countTarget.getSum();
            Target targetSum = this.computeSum(bpRatio, prevTargetSum, bin_i.getTarget(), bin_i1.getTarget());
            result = new SumResult<Target>(countSum, targetSum);
        }
        return result;
    }

    public double density(double p) {
        return this.extendedDensity(p).getCount();
    }

    public SumResult<T> extendedDensity(double p) {
        Object targetDensity;
        double countDensity;
        Object emptyTarget = ((Target)this._bins.first().getTarget()).init();
        Bin<T> exact = this._bins.get(p);
        if (p < this._minimum || p > this._maximum) {
            countDensity = 0.0;
            targetDensity = ((Target)emptyTarget).clone();
        } else if (p == this._minimum && p == this._maximum) {
            countDensity = Double.POSITIVE_INFINITY;
            targetDensity = emptyTarget;
        } else if (exact != null) {
            double higher = Math.nextAfter(p, Double.POSITIVE_INFINITY);
            double lower = Math.nextAfter(p, Double.NEGATIVE_INFINITY);
            SumResult<T> lowerResult = this.extendedDensity(lower);
            SumResult<T> higherResult = this.extendedDensity(higher);
            countDensity = (lowerResult.getCount() + higherResult.getCount()) / 2.0;
            targetDensity = ((Target)((Target)((Target)lowerResult.getTargetSum()).clone()).sum(higherResult.getTargetSum())).mult(0.5);
        } else {
            Bin<Object> higherBin;
            Bin<Object> lowerBin = this._bins.lower(p);
            if (lowerBin == null) {
                lowerBin = new Bin<Object>(this._minimum, 0.0, ((Target)emptyTarget).clone());
            }
            if ((higherBin = this._bins.higher(p)) == null) {
                higherBin = new Bin<Object>(this._maximum, 0.0, ((Target)emptyTarget).clone());
            }
            double bDiff = p - lowerBin.getMean();
            double pDiff = higherBin.getMean() - lowerBin.getMean();
            double bpRatio = bDiff / pDiff;
            NumericTarget countTarget = (NumericTarget)this.computeDensity(bpRatio, lowerBin.getMean(), higherBin.getMean(), new NumericTarget(lowerBin.getCount()), new NumericTarget(higherBin.getCount()));
            countDensity = countTarget.getSum();
            targetDensity = this.computeDensity(bpRatio, lowerBin.getMean(), higherBin.getMean(), lowerBin.getTarget(), higherBin.getTarget());
        }
        return new SumResult<Object>(countDensity, targetDensity);
    }

    public T averageTarget(double p) {
        SumResult<T> density = this.extendedDensity(p);
        return ((Target)density.getTargetSum()).mult(1.0 / density.getCount());
    }

    public ArrayList<Double> uniform(int numberOfBins) {
        ArrayList<Double> uniformBinSplits = new ArrayList<Double>();
        double totalCount = this.getTotalCount();
        if (totalCount > 0.0) {
            double gapSize = totalCount / (double)numberOfBins;
            double minGapSize = Math.max(this._bins.first().getCount(), this._bins.last().getCount()) / 2.0;
            int splits = numberOfBins;
            if (gapSize < minGapSize) {
                splits = (int)(totalCount / minGapSize);
                gapSize = totalCount / (double)splits;
            }
            for (int i = 1; i < splits; ++i) {
                double targetSum = (double)i * gapSize;
                double binSplit = this.findPointForSum(targetSum);
                uniformBinSplits.add(binSplit);
            }
        }
        return uniformBinSplits;
    }

    public HashMap<Double, Double> percentiles(Double ... percentiles) {
        HashMap<Double, Double> results = new HashMap<Double, Double>();
        double totalCount = this.getTotalCount();
        if (totalCount > 0.0) {
            Double[] arr$ = percentiles;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                double percentile = arr$[i$];
                double targetSum = percentile * totalCount;
                results.put(percentile, this.findPointForSum(targetSum));
            }
        }
        return results;
    }

    public Histogram merge(Histogram<T> histogram) throws MixedInsertException {
        if (this._indexMap == null && histogram._indexMap != null) {
            if (this.getBins().isEmpty()) {
                this._indexMap = histogram._indexMap;
            } else {
                throw new MixedInsertException();
            }
        }
        if (this._indexMap != null && !this._indexMap.equals(histogram._indexMap)) {
            throw new MixedInsertException();
        }
        if (!histogram.getBins().isEmpty()) {
            this.checkType(histogram.getTargetType());
            for (Bin<T> bin : histogram.getBins()) {
                Bin<T> newBin = new Bin<T>(bin);
                if (this._indexMap != null) {
                    ((ArrayCategoricalTarget)newBin.getTarget()).setIndexMap(this._indexMap);
                }
                this._bins.insert(new Bin<T>(bin));
            }
            this._bins.merge();
        }
        if (this._minimum == null) {
            this._minimum = histogram.getMinimum();
        } else if (histogram.getMinimum() != null) {
            this._minimum = Math.min(this._minimum, histogram.getMinimum());
        }
        if (this._maximum == null) {
            this._maximum = histogram.getMaximum();
        } else if (histogram.getMaximum() != null) {
            this._maximum = Math.max(this._maximum, histogram.getMaximum());
        }
        if (this._missingTarget == null) {
            this._missingTarget = histogram.getMissingTarget();
        } else if (histogram.getMissingTarget() != null) {
            ((Target)this._missingTarget).sum(histogram.getMissingTarget());
        }
        this._missingCount += histogram.getMissingCount();
        return this;
    }

    public double getTotalCount() {
        return this._bins.getTotalCount();
    }

    public Collection<Bin<T>> getBins() {
        return this._bins.getBins();
    }

    public JSONArray toJSON(DecimalFormat format) {
        JSONArray bins = new JSONArray();
        for (Bin<T> bin : this.getBins()) {
            bins.add((Object)bin.toJSON(format));
        }
        return bins;
    }

    public String toJSONString(DecimalFormat format) {
        return this.toJSON(format).toJSONString();
    }

    public String toString() {
        return this.toJSONString(this._decimalFormat);
    }

    public T getTotalTargetSum() {
        if (this._bins.getBins().isEmpty()) {
            return null;
        }
        return this.getPointToSumMap().get(this._maximum).getTargetSum();
    }

    public long getMissingCount() {
        return this._missingCount;
    }

    public T getMissingTarget() {
        return this._missingTarget;
    }

    public Histogram<T> insertMissing(long count, T target) {
        if (this._missingTarget == null) {
            this._missingTarget = target;
        } else {
            ((Target)this._missingTarget).sum(target);
        }
        this._missingCount += count;
        return this;
    }

    public Double getMinimum() {
        return this._minimum;
    }

    public Double getMaximum() {
        return this._maximum;
    }

    public Histogram setMinimum(Double minimum) {
        this._minimum = minimum;
        return this;
    }

    public Histogram setMaximum(Double maximum) {
        this._maximum = maximum;
        return this;
    }

    private void checkType(TargetType newType) throws MixedInsertException {
        if (this._targetType == null) {
            this._targetType = newType;
        } else if (this._targetType != newType || newType == null) {
            throw new MixedInsertException();
        }
    }

    private void processPointTarget(Double point, Target target) {
        if (point == null) {
            this.insertMissing(1L, target);
        } else {
            this.insertBin(new Bin<Target>(point, 1.0, target));
        }
    }

    private void clearCacheMaps() {
        this._sumToBinMap = null;
        this._pointToSumMap = null;
    }

    private void refreshCacheMaps() {
        Object emptyTarget = ((Target)this._bins.first().getTarget()).init();
        this._pointToSumMap = new TreeMap();
        this._pointToSumMap.put(this._minimum, new SumResult(0.0, emptyTarget));
        this._sumToBinMap = new TreeMap();
        Bin minBin = new Bin(this._minimum, 0.0, emptyTarget);
        Bin maxBin = new Bin(this._maximum, 0.0, emptyTarget);
        this._sumToBinMap.put(0.0, minBin);
        this._sumToBinMap.put(this.getTotalCount(), maxBin);
        SumResult sum = new SumResult(0.0, ((Target)emptyTarget).init());
        Bin lastBin = minBin;
        for (Bin<T> bin : this.getBins()) {
            sum = new SumResult(sum.getCount() + (bin.getCount() + lastBin.getCount()) / 2.0, ((Target)((Target)sum.getTargetSum()).clone()).sum(((Target)((Target)((Target)bin.getTarget()).clone()).sum(lastBin.getTarget())).mult(0.5)));
            this._sumToBinMap.put(sum.getCount(), bin);
            this._pointToSumMap.put(bin.getMean(), sum);
            lastBin = bin;
        }
        SumResult lastSumResult = new SumResult(sum.getCount() + lastBin.getCount() / 2.0, ((Target)((Target)sum.getTargetSum()).clone()).sum(((Target)((Target)lastBin.getTarget()).clone()).mult(0.5)));
        this._pointToSumMap.put(this._maximum, lastSumResult);
    }

    private TreeMap<Double, Bin<T>> getSumToBinMap() {
        if (this._sumToBinMap == null) {
            this.refreshCacheMaps();
        }
        return this._sumToBinMap;
    }

    private TreeMap<Double, SumResult<T>> getPointToSumMap() {
        if (this._pointToSumMap == null) {
            this.refreshCacheMaps();
        }
        return this._pointToSumMap;
    }

    private <U extends Target> Target computeSum(double r, U p, U i, U i1) {
        double i1Term = 0.5 * r * r;
        double iTerm = r - i1Term;
        return ((Target)((Target)p.clone()).sum(((Target)i.clone()).mult(iTerm))).sum(((Target)i1.clone()).mult(i1Term));
    }

    private <U extends Target> Target computeDensity(double r, double m, double m1, U i, U i1) {
        return ((Target)((Target)i.clone()).sum(((Target)((Target)i1.clone()).sum(((Target)i.clone()).mult(-1.0))).mult(r))).mult(1.0 / (m1 - m));
    }

    private double findPointForSum(double s) {
        double result;
        if (s <= 0.0) {
            result = this._minimum;
        } else if (s >= (double)this._bins.getTotalCount()) {
            result = this._maximum;
        } else {
            double u;
            Map.Entry<Double, Bin<T>> sumEntry = this.getSumToBinMap().floorEntry(s);
            double sumP_i = sumEntry.getKey();
            Bin<T> bin_i = sumEntry.getValue();
            double p_i = bin_i.getMean();
            double m_i = bin_i.getCount();
            Double sumP_i1 = this.getSumToBinMap().navigableKeySet().higher(sumP_i);
            Bin<T> bin_i1 = this.getSumToBinMap().get(sumP_i1);
            double p_i1 = bin_i1.getMean();
            double m_i1 = bin_i1.getCount();
            double d = s - sumP_i;
            double a = m_i1 - m_i;
            if (a == 0.0) {
                double offset = d / ((m_i + m_i1) / 2.0);
                u = p_i + offset * (p_i1 - p_i);
            } else {
                double b = 2.0 * m_i;
                double c = -2.0 * d;
                double z = Histogram.findZ(a, b, c);
                u = p_i + (p_i1 - p_i) * z;
            }
            result = u;
        }
        return result;
    }

    private static Double findZ(double a, double b, double c) {
        Double resultRoot = null;
        ArrayList<Double> candidateRoots = Histogram.solveQuadratic(a, b, c);
        for (Double candidateRoot : candidateRoots) {
            if (!(candidateRoot >= 0.0) || !(candidateRoot <= 1.0)) continue;
            resultRoot = candidateRoot;
            break;
        }
        return resultRoot;
    }

    private static ArrayList<Double> solveQuadratic(double a, double b, double c) {
        double discriminantSquareRoot = Math.sqrt(Math.pow(b, 2.0) - 4.0 * a * c);
        ArrayList<Double> roots = new ArrayList<Double>();
        roots.add((-b + discriminantSquareRoot) / (2.0 * a));
        roots.add((-b - discriminantSquareRoot) / (2.0 * a));
        return roots;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TargetType {
        none,
        numeric,
        categorical,
        group,
        histogram;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BinReservoirType {
        tree,
        array;

    }
}

