/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.histogram.spdt;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.streaminer.stream.histogram.spdt.CategoricalTarget;
import org.streaminer.stream.histogram.spdt.Histogram;
import org.streaminer.stream.histogram.spdt.Target;
import org.streaminer.util.math.NumberUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapCategoricalTarget
extends Target<MapCategoricalTarget>
implements CategoricalTarget {
    private HashMap<Object, Double> _counts;

    public MapCategoricalTarget(Object category) {
        this._counts = new HashMap(1, 1.0f);
        this._counts.put(category, 1.0);
    }

    public MapCategoricalTarget(HashMap<Object, Double> targetCounts, double missingCount) {
        this._counts = targetCounts;
        this._counts.put(null, missingCount);
    }

    public MapCategoricalTarget(HashMap<Object, Double> targetCounts) {
        this._counts = targetCounts;
    }

    public HashMap<Object, Double> getCounts() {
        return this._counts;
    }

    @Override
    public double getMissingCount() {
        Double missingCount = this._counts.get(null);
        return missingCount == null ? 0.0 : missingCount;
    }

    @Override
    public Histogram.TargetType getTargetType() {
        return Histogram.TargetType.categorical;
    }

    @Override
    protected void addJSON(JSONArray binJSON, DecimalFormat format) {
        JSONObject counts = new JSONObject();
        for (Map.Entry<Object, Double> categoryCount : this._counts.entrySet()) {
            Object category = categoryCount.getKey();
            double count = categoryCount.getValue();
            counts.put(category, (Object)NumberUtil.roundNumber(count, format));
        }
        binJSON.add((Object)counts);
    }

    @Override
    protected MapCategoricalTarget sum(MapCategoricalTarget target) {
        for (Map.Entry categoryCount : ((HashMap)target.getCounts()).entrySet()) {
            Object category = categoryCount.getKey();
            Double oldCount = this._counts.get(category);
            oldCount = oldCount == null ? 0.0 : oldCount;
            double newCount = oldCount + (Double)categoryCount.getValue();
            this._counts.put(category, newCount);
        }
        return this;
    }

    @Override
    protected MapCategoricalTarget mult(double multiplier) {
        for (Map.Entry entry : ((HashMap)this.getCounts()).entrySet()) {
            entry.setValue((Double)entry.getValue() * multiplier);
        }
        return this;
    }

    @Override
    protected MapCategoricalTarget clone() {
        return new MapCategoricalTarget(new HashMap<Object, Double>(this._counts));
    }

    @Override
    protected MapCategoricalTarget init() {
        return new MapCategoricalTarget(new HashMap<Object, Double>());
    }
}

