/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.histogram.spdt;

import java.text.DecimalFormat;
import org.json.simple.JSONArray;
import org.streaminer.stream.histogram.spdt.Histogram;
import org.streaminer.stream.histogram.spdt.Target;
import org.streaminer.util.math.NumberUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericTarget
extends Target<NumericTarget> {
    private Double _sum;
    private Double _sumSquares;
    private double _missingCount;

    public NumericTarget(Double target, Double sumSquares, double missingCount) {
        this._sum = target;
        this._sumSquares = sumSquares;
        this._missingCount = missingCount;
    }

    public NumericTarget(Double target, double missingCount) {
        this._sum = target;
        if (target != null) {
            this._sumSquares = target * target;
        }
        this._missingCount = missingCount;
    }

    public NumericTarget(Double target) {
        this(target, target == null ? 1.0 : 0.0);
    }

    public Double getSum() {
        return this._sum;
    }

    public Double getSumSquares() {
        return this._sumSquares;
    }

    @Override
    public double getMissingCount() {
        return this._missingCount;
    }

    @Override
    public Histogram.TargetType getTargetType() {
        return Histogram.TargetType.numeric;
    }

    public String toString() {
        return String.valueOf(this._sum) + "," + String.valueOf(this._sumSquares);
    }

    @Override
    protected void addJSON(JSONArray binJSON, DecimalFormat format) {
        if (this._sum == null) {
            binJSON.add(null);
        } else {
            binJSON.add((Object)NumberUtil.roundNumber(this._sum, format));
            binJSON.add((Object)NumberUtil.roundNumber(this._sumSquares, format));
        }
    }

    @Override
    protected NumericTarget init() {
        return new NumericTarget(0.0);
    }

    @Override
    protected NumericTarget clone() {
        return new NumericTarget(this._sum, this._sumSquares, this._missingCount);
    }

    @Override
    protected NumericTarget sum(NumericTarget target) {
        if (this._sum == null && target.getSum() != null) {
            this._sum = target.getSum();
            this._sumSquares = target.getSumSquares();
        } else if (this._sum != null && target.getSum() != null) {
            this._sum = this._sum + target.getSum();
            this._sumSquares = this._sumSquares + target.getSumSquares();
        }
        this._missingCount += target.getMissingCount();
        return this;
    }

    @Override
    protected NumericTarget mult(double multiplier) {
        if (this._sum != null) {
            this._sum = this._sum * multiplier;
            this._sumSquares = this._sumSquares * multiplier;
        }
        this._missingCount *= multiplier;
        return this;
    }
}

