/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.histogram.spdt;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.streaminer.stream.histogram.spdt.Bin;
import org.streaminer.stream.histogram.spdt.BinReservoir;
import org.streaminer.stream.histogram.spdt.Gap;
import org.streaminer.stream.histogram.spdt.Target;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeBinReservoir<T extends Target>
extends BinReservoir<T> {
    private final TreeMap<Double, Bin<T>> _bins = new TreeMap();
    private final TreeSet<Gap<T>> _gaps = new TreeSet();
    private final HashMap<Double, Gap<T>> _binsToGaps = new HashMap();

    public TreeBinReservoir(int maxBins, boolean weightGaps, Long freezeThreshold) {
        super(maxBins, weightGaps, freezeThreshold);
    }

    @Override
    public void insert(Bin<T> bin) {
        this.addTotalCount(bin);
        if (this.isFrozen() && this.getBins().size() == this.getMaxBins()) {
            Double floorDiff = Double.MAX_VALUE;
            Bin<T> floorBin = this.floor(bin.getMean());
            if (floorBin != null) {
                floorDiff = Math.abs(floorBin.getMean() - bin.getMean());
            }
            Double ceilDiff = Double.MAX_VALUE;
            Bin<T> ceilBin = this.ceiling(bin.getMean());
            if (ceilBin != null) {
                ceilDiff = Math.abs(ceilBin.getMean() - bin.getMean());
            }
            if (floorDiff <= ceilDiff) {
                floorBin.sumUpdate(bin);
            } else {
                ceilBin.sumUpdate(bin);
            }
        } else {
            Bin<T> existingBin = this.get(bin.getMean());
            if (existingBin != null) {
                existingBin.sumUpdate(bin);
                if (this.isWeightGaps()) {
                    this.updateGaps(existingBin);
                }
            } else {
                this.updateGaps(bin);
                this._bins.put(bin.getMean(), bin);
            }
        }
    }

    @Override
    public Bin<T> first() {
        return this.binFromEntry(this._bins.firstEntry());
    }

    @Override
    public Bin<T> last() {
        return this.binFromEntry(this._bins.lastEntry());
    }

    @Override
    public Bin<T> get(double p) {
        return this._bins.get(p);
    }

    @Override
    public Bin<T> floor(double p) {
        return this.binFromEntry(this._bins.floorEntry(p));
    }

    @Override
    public Bin<T> ceiling(double p) {
        return this.binFromEntry(this._bins.ceilingEntry(p));
    }

    @Override
    public Bin<T> higher(double p) {
        return this.binFromEntry(this._bins.higherEntry(p));
    }

    @Override
    public Bin<T> lower(double p) {
        return this.binFromEntry(this._bins.lowerEntry(p));
    }

    @Override
    public Collection<Bin<T>> getBins() {
        return this._bins.values();
    }

    @Override
    public void merge() {
        while (this._bins.size() > this.getMaxBins()) {
            Gap<T> smallestGap = this._gaps.pollFirst();
            Bin newBin = smallestGap.getStartBin().combine(smallestGap.getEndBin());
            Gap<T> followingGap = this._binsToGaps.get(smallestGap.getEndBin().getMean());
            if (followingGap != null) {
                this._gaps.remove(followingGap);
            }
            this._bins.remove(smallestGap.getStartBin().getMean());
            this._bins.remove(smallestGap.getEndBin().getMean());
            this._binsToGaps.remove(smallestGap.getStartBin().getMean());
            this._binsToGaps.remove(smallestGap.getEndBin().getMean());
            this.updateGaps(newBin);
            this._bins.put(newBin.getMean(), newBin);
        }
    }

    private void updateGaps(Bin<T> newBin) {
        Bin<T> next;
        Bin<T> prev = this.lower(newBin.getMean());
        if (prev != null) {
            this.updateGaps(prev, newBin);
        }
        if ((next = this.higher(newBin.getMean())) != null) {
            this.updateGaps(newBin, next);
        }
    }

    private void updateGaps(Bin<T> prev, Bin<T> next) {
        Gap<T> newGap = new Gap<T>(prev, next, this.gapWeight(prev, next));
        Gap<T> prevGap = this._binsToGaps.get(prev.getMean());
        if (prevGap != null) {
            this._gaps.remove(prevGap);
        }
        this._binsToGaps.put(prev.getMean(), newGap);
        this._gaps.add(newGap);
    }

    private Bin<T> binFromEntry(Map.Entry<Double, Bin<T>> entry) {
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }
}

