/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.learner;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.streaminer.stream.data.Data;
import org.streaminer.stream.data.DataUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LearnerUtils
extends DataUtils {
    public static String detectLabelAttribute(Data item) {
        String label = null;
        for (String key : item.keySet()) {
            if (LearnerUtils.isLabel(key)) {
                return key;
            }
            label = key;
        }
        return label;
    }

    public static boolean isLabel(String name) {
        return name.startsWith("@label") || name.equals("label") || name.startsWith("class") || name.startsWith("_class");
    }

    public static boolean isPrediction(String name) {
        return name.startsWith("@pred");
    }

    public static Set<String> getLabelAttributes(Data item) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String key : item.keySet()) {
            if (!LearnerUtils.isLabel(key)) continue;
            set.add(key);
        }
        return set;
    }

    public static Set<String> getAttributes(Data item) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String key : item.keySet()) {
            if (LearnerUtils.isLabel(key) || LearnerUtils.isHidden(key) || LearnerUtils.isAnnotation(key)) continue;
            set.add(key);
        }
        return set;
    }

    public static Set<String> getNumericAttributes(Data item) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String key : item.keySet()) {
            if (LearnerUtils.isLabel(key) || LearnerUtils.isHidden(key) || !LearnerUtils.isNumerical(key, item)) continue;
            set.add(key);
        }
        return set;
    }

    public static Map<String, Double> getNumericVector(Data item) {
        LinkedHashMap<String, Double> set = new LinkedHashMap<String, Double>();
        for (String key : item.keySet()) {
            if (LearnerUtils.isLabel(key) || LearnerUtils.isHidden(key) || !LearnerUtils.isNumerical(key, item) && LearnerUtils.parseDouble(key, item) == null) continue;
            set.put(key, LearnerUtils.parseDouble(key, item));
        }
        return set;
    }

    public static Serializable getLabel(Data item) {
        Set<String> set = LearnerUtils.getLabelAttributes(item);
        if (set.isEmpty()) {
            return null;
        }
        return (Serializable)item.get(set.iterator().next());
    }

    public static Double parseDouble(String key, Data item) {
        try {
            return new Double(((Serializable)item.get(key)).toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isNumerical(String key, Data item) {
        return item.containsKey(key) && ((Serializable)item.get(key)).getClass() == Double.class;
    }

    public static boolean isNominal(String key, Data item) {
        return !LearnerUtils.isNumerical(key, item);
    }

    public static Double getDouble(String key, Data item) {
        if (LearnerUtils.isNumerical(key, item)) {
            return (Double)item.get(key);
        }
        return Double.NaN;
    }

    public static Map<String, Class<?>> getTypes(Data item) {
        LinkedHashMap types = new LinkedHashMap();
        for (String key : item.keySet()) {
            if (LearnerUtils.isNumerical(key, item)) {
                types.put(key, Double.class);
                continue;
            }
            types.put(key, String.class);
        }
        return types;
    }

    public static Map<String, Class<?>> getTypes(Collection<Data> items) {
        LinkedHashMap types = new LinkedHashMap();
        for (Data item : items) {
            for (String key : item.keySet()) {
                if (LearnerUtils.isNumerical(key, item)) {
                    types.put(key, Double.class);
                    continue;
                }
                types.put(key, String.class);
            }
        }
        return types;
    }

    public static String getMaximumKey(Map<String, Double> input) {
        String bestFeature = null;
        Double bestValue = null;
        for (String feature : input.keySet()) {
            if (bestValue != null && bestValue.compareTo(input.get(feature)) >= 0) continue;
            bestFeature = feature;
            bestValue = input.get(feature);
        }
        return bestFeature;
    }
}

