/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.mapper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.streaminer.stream.mapper.IMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddMax
implements IMapper<Map<String, Object>, Map<String, Object>> {
    Set<String> features;
    Map<String, Double> maxima = new HashMap<String, Double>();

    @Override
    public Map<String, Object> map(Map<String, Object> input) throws Exception {
        this.detectNumericFeatures(input);
        for (String f : this.features) {
            if (!input.containsKey(f)) continue;
            try {
                Double val = (Double)input.get(f);
                Double max = this.maxima.get(f);
                max = max == null ? val : Double.valueOf(Math.max(max, val));
                this.maxima.put(f, max);
                input.put("MAX(" + f + ")", max);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return input;
    }

    public void detectNumericFeatures(Map<String, Object> datum) {
        if (this.features == null) {
            this.features = new HashSet<String>();
        }
        for (String key : datum.keySet()) {
            if (this.features.contains(key) || !datum.get(key).equals(Double.class)) continue;
            this.features.add(key);
        }
    }
}

