/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.mapper;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.data.Data;
import org.streaminer.stream.mapper.IMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyMapper
implements IMapper<Data, Data> {
    static Logger log = LoggerFactory.getLogger(KeyMapper.class);
    String oldKey;
    String newKey;

    public KeyMapper(String oldKey, String newKey) {
        this.oldKey = oldKey;
        this.newKey = newKey;
    }

    public KeyMapper() {
        this.oldKey = "";
        this.newKey = "";
    }

    public String getOld() {
        return this.oldKey;
    }

    public void setOld(String oldKey) {
        this.oldKey = oldKey;
    }

    public String getNew() {
        return this.newKey;
    }

    public void setNew(String newKey) {
        this.newKey = newKey;
    }

    @Override
    public Data map(Data input) throws Exception {
        if (input.containsKey(this.oldKey)) {
            if (input.containsKey(this.newKey)) {
                log.warn("Overwriting existing key '{}'!", (Object)this.newKey);
            }
            Serializable o = (Serializable)input.remove(this.oldKey);
            input.put(this.newKey, o);
        }
        return input;
    }
}

