/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.mapper;

import org.streaminer.stream.data.Data;
import org.streaminer.stream.learner.LearnerUtils;
import org.streaminer.stream.mapper.IMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Normalization
implements IMapper<Data, Data> {
    String attribute = ".*";
    Double minimum = -10.0;
    Double maximum = 10.0;
    double range = Math.abs(this.maximum - this.minimum);
    double offset = 0.5 * (this.maximum - this.minimum);

    @Override
    public Data map(Data data) {
        for (String key : data.keySet()) {
            if (!key.matches(this.attribute) || !LearnerUtils.isNumerical(key, data)) continue;
            Double value = LearnerUtils.getDouble(key, data);
            data.put(key, this.normalize(value));
        }
        return data;
    }

    protected void update() {
        this.range = Math.abs(this.maximum - this.minimum);
        this.offset = 0.5 * this.range;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Double minimum) {
        this.minimum = minimum;
        this.update();
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Double maximum) {
        this.maximum = maximum;
        this.update();
    }

    protected Double normalize(Double d) {
        Double v = d;
        if (d < this.minimum) {
            v = this.minimum;
        }
        if (d > this.maximum) {
            v = this.maximum;
        }
        return (v + this.offset) / this.range;
    }
}

