/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.mapper;

import java.io.Serializable;
import org.streaminer.stream.data.Data;
import org.streaminer.stream.data.DataUtils;
import org.streaminer.stream.mapper.IMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericalBinning
implements IMapper<Data, Data> {
    Double minimum = 0.0;
    Double maximum = 10.0;
    Integer bins = 10;
    String include = ".*";
    double[] buckets = null;

    public Double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Double minimum) {
        this.minimum = minimum;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Double maximum) {
        this.maximum = maximum;
    }

    public Integer getBins() {
        return this.bins;
    }

    public void setBins(Integer bins) {
        this.bins = bins;
        this.buckets = null;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    private void init() {
        this.buckets = new double[Math.max(1, this.bins)];
        double step = (this.maximum - this.minimum) / this.bins.doubleValue();
        this.buckets[0] = 0.0;
        for (int i = 1; i < this.buckets.length; ++i) {
            this.buckets[i] = this.buckets[i - 1] + step;
        }
    }

    @Override
    public Data map(Data data) {
        if (this.buckets == null) {
            this.init();
        }
        for (String key : DataUtils.getKeys(data)) {
            if (this.include != null && !key.matches(this.include) || ((Serializable)data.get(key)).getClass() != Double.class) continue;
            data.put(key, this.map((Double)data.get(key)));
        }
        return data;
    }

    @Override
    protected String map(Double d) {
        if (d < this.buckets[0]) {
            return "bucket[first]";
        }
        for (int i = 0; i < this.buckets.length; ++i) {
            if (i + 1 >= this.buckets.length || !(this.buckets[i + 1] > d)) continue;
            return "bucket[" + i + "]";
        }
        return "bucket[last]";
    }
}

