/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.membership;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.streaminer.stream.membership.HashFunction;
import org.streaminer.stream.membership.IFilter;
import org.streaminer.stream.membership.Key;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFilter
implements IFilter<Key> {
    private static final int VERSION = -1;
    protected int vectorSize;
    protected HashFunction hash;
    protected int nbHash;
    protected int hashType;

    protected AbstractFilter() {
    }

    protected AbstractFilter(int vectorSize, int nbHash, int hashType) {
        this.vectorSize = vectorSize;
        this.nbHash = nbHash;
        this.hashType = hashType;
        this.hash = new HashFunction(this.vectorSize, this.nbHash, this.hashType);
    }

    @Override
    public abstract void add(Key var1);

    @Override
    public abstract boolean membershipTest(Key var1);

    public abstract void and(AbstractFilter var1);

    public abstract void or(AbstractFilter var1);

    public abstract void xor(AbstractFilter var1);

    public abstract void not();

    @Override
    public void add(List<Key> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("ArrayList<Key> may not be null");
        }
        for (Key key : keys) {
            this.add(key);
        }
    }

    @Override
    public void add(Collection<Key> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Collection<Key> may not be null");
        }
        for (Key key : keys) {
            this.add(key);
        }
    }

    @Override
    public void add(Key[] keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Key[] may not be null");
        }
        for (int i = 0; i < keys.length; ++i) {
            this.add(keys[i]);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(-1);
        out.writeInt(this.nbHash);
        out.writeByte(this.hashType);
        out.writeInt(this.vectorSize);
    }

    public void readFields(DataInput in) throws IOException {
        int ver = in.readInt();
        if (ver > 0) {
            this.nbHash = ver;
            this.hashType = 0;
        } else if (ver == -1) {
            this.nbHash = in.readInt();
            this.hashType = in.readByte();
        } else {
            throw new IOException("Unsupported version: " + ver);
        }
        this.vectorSize = in.readInt();
        this.hash = new HashFunction(this.vectorSize, this.nbHash, this.hashType);
    }
}

