/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.membership;

public class DLeftCountingBloomFilter {
    private static final int HASH_BYTES = 20;
    private static final int BUCKET_HEIGHT = 8;
    private static final int FINGERPRINT_BITS = 13;
    private int width;
    private int height;
    private long bits;
    private Bucket[][] buckets;

    public DLeftCountingBloomFilter(int d, int b) {
        this.width = d;
        this.height = b;
        this.bits = Math.round(Math.log(b) / Math.log(2.0));
        this.buckets = new Bucket[d][b];
    }

    private void getTargets(byte[] hash) {
        int i = 0;
        int pos = 0;
        while (i < this.width) {
            long p = this.getBits(hash, this.bits, pos);
            ++i;
            pos += 13;
        }
    }

    protected long getBits(byte[] input, long numBits, int pos) {
        long start;
        long value = 0L;
        long postBits = pos % 8;
        int i = pos / 8;
        long l = start = postBits > numBits ? numBits : postBits;
        if (start != 0L) {
            value = input[i++] & 255 >> (int)(8L - start);
            numBits -= start;
        }
        while (numBits >= 8L) {
            value = value << 8 | (long)input[i++];
            numBits -= 8L;
        }
        if (numBits != 0L) {
            long last = input[i] >> (int)(8L - numBits);
            value = value << (int)numBits | last;
        }
        return value;
    }

    private static class Bucket {
        private Bucket() {
        }
    }
}

