/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.membership;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.WritableComparable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class Key
implements WritableComparable<Key> {
    byte[] bytes;
    double weight;

    public Key() {
    }

    public Key(byte[] value) {
        this(value, 1.0);
    }

    public Key(byte[] value, double weight) {
        this.set(value, weight);
    }

    public void set(byte[] value, double weight) {
        if (value == null) {
            throw new IllegalArgumentException("value can not be null");
        }
        this.bytes = value;
        this.weight = weight;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public double getWeight() {
        return this.weight;
    }

    public void incrementWeight(double weight) {
        this.weight += weight;
    }

    public void incrementWeight() {
        this.weight += 1.0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Key)) {
            return false;
        }
        return this.compareTo((Key)o) == 0;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.bytes.length; ++i) {
            result ^= Byte.valueOf(this.bytes[i]).hashCode();
        }
        return result ^= Double.valueOf(this.weight).hashCode();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.bytes.length);
        out.write(this.bytes);
        out.writeDouble(this.weight);
    }

    public void readFields(DataInput in) throws IOException {
        this.bytes = new byte[in.readInt()];
        in.readFully(this.bytes);
        this.weight = in.readDouble();
    }

    public int compareTo(Key other) {
        int result = this.bytes.length - other.getBytes().length;
        for (int i = 0; result == 0 && i < this.bytes.length; ++i) {
            result = this.bytes[i] - other.bytes[i];
        }
        if (result == 0) {
            result = Double.valueOf(this.weight - other.weight).intValue();
        }
        return result;
    }
}

