/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.membership;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.streaminer.stream.membership.BloomCalculations;
import org.streaminer.stream.membership.IFilter;
import org.streaminer.util.hash.MurmurHash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODTDBloomFilter
implements IFilter<String> {
    private static final MurmurHash hasher = new MurmurHash();
    private int bucketsPerWord;
    private int hashCount;
    private int numBuckets;
    private double[][] buckets;
    private long[] timers;
    private double beta;

    public ODTDBloomFilter(int numElements, int bucketsPerElement, double beta) {
        this(numElements, bucketsPerElement, beta, 16);
    }

    public ODTDBloomFilter(int numElements, int bucketsPerElement, double beta, int bucketsPerWord) {
        this.beta = beta;
        this.bucketsPerWord = bucketsPerWord;
        this.hashCount = BloomCalculations.computeBestK(bucketsPerElement);
        this.numBuckets = (numElements * bucketsPerElement + 20) / bucketsPerWord;
        this.buckets = new double[this.numBuckets][bucketsPerWord];
        this.timers = new long[this.numBuckets];
    }

    @Override
    public boolean membershipTest(String item) {
        for (int bucketIndex : this.getHashBuckets(item)) {
            if (this.getBucket(bucketIndex) != 0.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void add(String item) {
        this.add(item, 1, ODTDBloomFilter.time());
    }

    public void add(String item, int q) {
        this.add(item, q, ODTDBloomFilter.time());
    }

    public void add(String item, int q, long timestamp) {
        assert (item != null);
        double count = this.estimateCount(item, timestamp) + (double)q * Math.log(1.0 / this.beta);
        for (int bucketIndex : this.getHashBuckets(item)) {
            if (!(this.getBucket(bucketIndex) < count)) continue;
            this.setBucket(bucketIndex, count);
        }
    }

    public void delete(String item, int q) {
        if (!this.membershipTest(item)) {
            throw new IllegalArgumentException("key is not present");
        }
        for (int bucketIndex : this.getHashBuckets(item)) {
            if (!(this.getBucket(bucketIndex) >= (double)q)) continue;
            this.addToBucket(bucketIndex, -q);
        }
    }

    public double estimateCount(String item) {
        return this.estimateCount(item, ODTDBloomFilter.time());
    }

    public double estimateCount(String item, long time) {
        double res = Double.MAX_VALUE;
        for (int bucketIndex : this.getHashBuckets(item)) {
            double value = this.getBucket(bucketIndex) * Math.pow(this.beta, time - this.getTimer(bucketIndex));
            this.setBucket(bucketIndex, value);
            this.setTimer(bucketIndex, time);
            if (!(value < res)) continue;
            res = value;
        }
        return res != Double.MAX_VALUE ? res : 0.0;
    }

    public void clear() {
        for (int i = 0; i < this.buckets.length; ++i) {
            Arrays.fill(this.buckets[i], 0.0);
        }
        Arrays.fill(this.timers, 0L);
    }

    private int buckets() {
        return this.buckets.length * this.bucketsPerWord;
    }

    private int[] getHashBuckets(String item) {
        return ODTDBloomFilter.getHashBuckets(item, this.hashCount, this.buckets());
    }

    public static int[] getHashBuckets(String item, int hashCount, int max) {
        byte[] b;
        try {
            b = item.getBytes("UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        int[] result = new int[hashCount];
        int hash1 = hasher.hash(b, b.length, 0);
        int hash2 = hasher.hash(b, b.length, hash1);
        for (int i = 0; i < hashCount; ++i) {
            result[i] = Math.abs((hash1 + i * hash2) % max);
        }
        return result;
    }

    private static long time() {
        return System.currentTimeMillis() / 1000L;
    }

    private double getBucket(int bucketIndex) {
        return this.buckets[bucketIndex / this.bucketsPerWord][bucketIndex % this.bucketsPerWord];
    }

    private void addToBucket(int bucketIndex, double value) {
        double[] dArray = this.buckets[bucketIndex / this.bucketsPerWord];
        int n = bucketIndex % this.bucketsPerWord;
        dArray[n] = dArray[n] + value;
    }

    private void setBucket(int bucketIndex, double value) {
        this.buckets[bucketIndex / this.bucketsPerWord][bucketIndex % this.bucketsPerWord] = value;
    }

    private long getTimer(int bucketIndex) {
        return this.timers[bucketIndex / this.bucketsPerWord];
    }

    private void setTimer(int bucketIndex, long value) {
        this.timers[bucketIndex / this.bucketsPerWord] = value;
    }
}

