/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.membership;

import com.google.common.hash.Funnel;
import com.google.common.hash.Hashing;
import org.streaminer.stream.membership.IFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StableBloomFilter<T>
implements IFilter<T> {
    private static final int MAX_VAL = 3;
    private final int[] cells;
    private final int numHashFunctions;
    private final Funnel<T> funnel;
    private final Murmur128_Mitz_32_Strategy strategy;
    private final int numDecrementCells;

    public StableBloomFilter(int numCells, int numHashFunctions, int numDecrementCells, Funnel<T> funnel) {
        this.numDecrementCells = numDecrementCells;
        this.cells = new int[numCells];
        this.numHashFunctions = numHashFunctions;
        this.funnel = funnel;
        this.strategy = new Murmur128_Mitz_32_Strategy();
    }

    @Override
    public boolean membershipTest(T object) {
        return this.strategy.mightContain(object, this.funnel, this.numHashFunctions, this.cells);
    }

    @Override
    public void add(T object) {
        this.decrementCells();
        this.strategy.put(object, this.funnel, this.numHashFunctions, this.cells);
    }

    private void decrementCells() {
        int min = 0;
        int max = this.cells.length - 1;
        int decrementPos = min + (int)(Math.random() * (double)(max - min + 1));
        for (int i = 0; i < this.numDecrementCells; ++i) {
            if (decrementPos >= this.cells.length) {
                decrementPos = 0;
            }
            if (this.cells[decrementPos] > 0) {
                this.cells[decrementPos] = this.cells[decrementPos] - 1;
            }
            ++decrementPos;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Murmur128_Mitz_32_Strategy {
        private Murmur128_Mitz_32_Strategy() {
        }

        public <T> boolean put(T object, Funnel<? super T> funnel, int numHashFunctions, int[] cells) {
            long hash64 = Hashing.murmur3_128().newHasher().putObject(object, funnel).hash().asLong();
            int hash1 = (int)hash64;
            int hash2 = (int)(hash64 >>> 32);
            boolean bitsChanged = false;
            for (int i = 1; i <= numHashFunctions; ++i) {
                int pos;
                int nextHash = hash1 + i * hash2;
                if (nextHash < 0) {
                    nextHash ^= 0xFFFFFFFF;
                }
                bitsChanged |= cells[pos = nextHash % cells.length] != 3;
                cells[pos] = 3;
            }
            return bitsChanged;
        }

        public <T> boolean mightContain(T object, Funnel<? super T> funnel, int numHashFunctions, int[] cells) {
            long hash64 = Hashing.murmur3_128().newHasher().putObject(object, funnel).hash().asLong();
            int hash1 = (int)hash64;
            int hash2 = (int)(hash64 >>> 32);
            for (int i = 1; i <= numHashFunctions; ++i) {
                int pos;
                int nextHash = hash1 + i * hash2;
                if (nextHash < 0) {
                    nextHash ^= 0xFFFFFFFF;
                }
                if (cells[pos = nextHash % cells.length] != 0) continue;
                return false;
            }
            return true;
        }
    }
}

