/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.membership;

import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.util.hash.MurmurHash3;

public class TimingBloomFilter
extends TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(TimingBloomFilter.class);
    private static final int ENTRIES_PER_8BYTE = 1;
    private int capacity;
    private int numBytes;
    private int numHashes;
    private int decayTime;
    private int ringSize;
    private int dN;
    private int numNonZero;
    private int[] data;
    private double error;
    private double secondsPerTick;
    private Timer timer;
    private MurmurHash3 hash;
    private int seed;

    public TimingBloomFilter(int capacity, int decayTime) {
        this(capacity, decayTime, 0.005);
    }

    public TimingBloomFilter(int capacity, int decayTime, double error) {
        this.capacity = capacity;
        this.decayTime = decayTime;
        this.error = error;
        this.initialize();
    }

    private void initialize() {
        this.hash = new MurmurHash3();
        this.seed = (int)System.nanoTime();
        this.timer = new Timer(this.getClass().getName() + "Timer");
        this.numNonZero = 0;
        this.numBytes = (int)((double)(-this.capacity) * Math.log(this.error) / Math.pow(Math.log(2.0), 2.0)) + 1;
        this.numHashes = (int)((double)(this.numBytes / this.capacity) * Math.log(2.0)) + 1;
        this.data = new int[(int)Math.ceil(this.numBytes / 1)];
        this.ringSize = 255;
        this.dN = this.ringSize / 2;
        this.secondsPerTick = (double)this.decayTime / (double)this.dN;
    }

    public void startDecay() {
        long timePerDecay = (long)(this.secondsPerTick * 1000.0);
        this.timer.scheduleAtFixedRate((TimerTask)this, timePerDecay, timePerDecay);
    }

    public void decay() {
        this.run();
    }

    public void run() {
        int[] tick = this.tickRange();
        this.numNonZero = 0;
        for (int i = 0; i < this.numBytes; ++i) {
            if (this.data[i] == 0) continue;
            if (!this.testInterval(tick, this.data[i])) {
                this.data[i] = 0;
                continue;
            }
            ++this.numNonZero;
        }
    }

    private int[] indexes(Object key) {
        long[] h = this.hash.hash64(key, this.seed);
        int[] indexes = new int[this.numHashes];
        for (int i = 0; i < this.numHashes; ++i) {
            indexes[i] = (int)Math.abs((h[0] + (long)i * h[1]) % (long)this.numBytes);
        }
        return indexes;
    }

    private int tick(long timestamp) {
        return (int)((double)timestamp / this.secondsPerTick % (double)this.ringSize) + 1;
    }

    private long time() {
        return System.currentTimeMillis() / 1000L;
    }

    private int[] tickRange() {
        int tickMax = this.tick(this.time());
        int tickMin = (tickMax - this.dN - 1) % this.ringSize + 1;
        return new int[]{tickMin, tickMax};
    }

    public void add(Object key) {
        this.add(key, this.time());
    }

    public void add(Object key, long timestamp) {
        int tick = this.tick(timestamp);
        if (timestamp < this.time() - (long)this.decayTime) {
            return;
        }
        for (int index : this.indexes(key)) {
            this.numNonZero += this.data[index] == 0 ? 1 : 0;
            this.data[index] = tick;
        }
    }

    private boolean testInterval(int[] ticks, int data) {
        if (ticks[0] < ticks[1]) {
            return ticks[0] < data && data <= ticks[1];
        }
        return data != 0 && (ticks[1] >= data || data > ticks[0]);
    }

    public boolean membershipTest(Object key) {
        int[] ticks = this.tickRange();
        for (int index : this.indexes(key)) {
            if (this.testInterval(ticks, this.data[index])) continue;
            return false;
        }
        return true;
    }

    public double getError() {
        return this.error;
    }
}

