/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.membership;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.streaminer.stream.membership.BloomCalculations;
import org.streaminer.stream.membership.IFilter;
import org.streaminer.util.hash.MurmurHash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarCountingBloomFilter
implements IFilter<String> {
    private static final MurmurHash hasher = new MurmurHash();
    private long maxCount = 15L;
    private int bucketsPerWord = 16;
    private int exp;
    private int hashCount;
    private int numNonZero;
    private int numBuckets;
    private long[] buckets;

    public VarCountingBloomFilter(int numElements, int bucketsPerElement, int exp) {
        this.exp = exp;
        this.bucketsPerWord = (int)Math.pow(2.0, exp);
        this.maxCount = this.bucketsPerWord - 1;
        this.hashCount = BloomCalculations.computeBestK(bucketsPerElement);
        this.numBuckets = (numElements * bucketsPerElement + 20) / this.bucketsPerWord;
        this.numNonZero = 0;
        this.buckets = new long[this.numBuckets];
    }

    public void clear() {
        Arrays.fill(this.buckets, 0L);
        this.numNonZero = 0;
    }

    public void merge(VarCountingBloomFilter cbf) {
        assert (cbf != null);
        assert (this.buckets.length == cbf.buckets.length);
        assert (this.hashCount == cbf.hashCount);
        for (int i = 0; i < this.buckets(); ++i) {
            Bucket b = new Bucket(i);
            Bucket b2 = cbf.getBucket(i);
            long merged = b.value + b2.value;
            b.set(merged > this.maxCount ? this.maxCount : merged);
        }
    }

    @Override
    public boolean membershipTest(String item) {
        for (int bucketIndex : this.getHashBuckets(item)) {
            Bucket bucket = new Bucket(bucketIndex);
            if (bucket.value != 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public void add(String item) {
        assert (item != null);
        for (int bucketIndex : this.getHashBuckets(item)) {
            Bucket bucket = new Bucket(bucketIndex);
            if (bucket.value >= this.maxCount) continue;
            if (bucket.value == 0L) {
                ++this.numNonZero;
            }
            bucket.set(bucket.value + 1L);
        }
    }

    public void delete(String item) {
        if (!this.membershipTest(item)) {
            throw new IllegalArgumentException("key is not present");
        }
        for (int bucketIndex : this.getHashBuckets(item)) {
            Bucket bucket = new Bucket(bucketIndex);
            if (bucket.value < 1L || bucket.value >= this.maxCount) continue;
            bucket.set(bucket.value - 1L);
            if (bucket.value - 1L != 0L) continue;
            --this.numNonZero;
        }
    }

    public double getPercentNonZero() {
        return (double)this.numNonZero / (double)this.numBuckets;
    }

    private Bucket getBucket(int i) {
        return new Bucket(i);
    }

    private int buckets() {
        return this.buckets.length * this.bucketsPerWord;
    }

    protected int emptyBuckets() {
        int n = 0;
        for (int i = 0; i < this.buckets(); ++i) {
            if ((VarCountingBloomFilter)this.new Bucket((int)i).value != 0L) continue;
            ++n;
        }
        return n;
    }

    protected int maxBucket() {
        int max = 0;
        for (int i = 0; i < this.buckets(); ++i) {
            Bucket bucket = new Bucket(i);
            if (bucket.value <= (long)max) continue;
            max = (int)bucket.value;
        }
        return max;
    }

    private int[] getHashBuckets(String key) {
        return VarCountingBloomFilter.getHashBuckets(key, this.hashCount, this.buckets());
    }

    private static int[] getHashBuckets(String key, int hashCount, int max) {
        byte[] b;
        try {
            b = key.getBytes("UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        int[] result = new int[hashCount];
        int hash1 = hasher.hash(b, b.length, 0);
        int hash2 = hasher.hash(b, b.length, hash1);
        for (int i = 0; i < hashCount; ++i) {
            result[i] = Math.abs((hash1 + i * hash2) % max);
        }
        return result;
    }

    private class Bucket {
        public final int wordIndex;
        public final int shift;
        public final long mask;
        public final long value;

        public Bucket(int bucketIndex) {
            this.wordIndex = bucketIndex >> VarCountingBloomFilter.this.exp;
            this.shift = (bucketIndex & 0xF) << 2;
            this.mask = VarCountingBloomFilter.this.maxCount << this.shift;
            this.value = (VarCountingBloomFilter.this.buckets[this.wordIndex] & this.mask) >>> this.shift;
        }

        void set(long val) {
            ((VarCountingBloomFilter)VarCountingBloomFilter.this).buckets[this.wordIndex] = VarCountingBloomFilter.this.buckets[this.wordIndex] & (this.mask ^ 0xFFFFFFFFFFFFFFFFL) | val << this.shift;
        }
    }
}

