/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.misc;

import java.util.concurrent.LinkedBlockingDeque;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovingWindowDelta<T extends Number> {
    private static final int DEFAULT_WINDOW_SIZE = 60;
    private final LinkedBlockingDeque<Long> deltaSeries;
    private long sumDelta = 0L;
    private long lastInput = 0L;

    public MovingWindowDelta() {
        this(60);
    }

    public MovingWindowDelta(int windowSize) {
        if (windowSize < 1) {
            throw new IllegalArgumentException("windowSize should be greater than zero");
        }
        this.deltaSeries = new LinkedBlockingDeque(windowSize);
    }

    public void add(T num) {
        long lastDelta = 0L;
        if (this.deltaSeries.remainingCapacity() == 0) {
            lastDelta = this.deltaSeries.removeFirst();
        }
        long newInput = ((Number)num).longValue();
        long newDelta = newInput - this.lastInput;
        this.lastInput = newInput;
        this.deltaSeries.addLast(newDelta);
        this.sumDelta += newDelta - lastDelta;
    }

    public long getDelta() {
        return this.sumDelta;
    }
}

