/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.misc;

import com.google.common.base.Ticker;
import java.util.concurrent.LinkedBlockingDeque;
import org.streaminer.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rate<T extends Number> {
    private static final int DEFAULT_WINDOW_SIZE = 1;
    private static final double DEFAULT_SCALE_FACTOR = 1.0;
    private static final long NANOS_PER_SEC = 1000000000L;
    private final Ticker ticker;
    private final double scaleFactor;
    private final LinkedBlockingDeque<Pair<Long, Double>> samples;

    public Rate(int windowSize, double scaleFactor, Ticker ticker) {
        if (scaleFactor == 0.0) {
            throw new IllegalArgumentException("Scale factor must be non-zero!");
        }
        this.ticker = ticker;
        this.scaleFactor = scaleFactor;
        this.samples = new LinkedBlockingDeque(windowSize);
    }

    public double add(T newSample) {
        long newTimestamp = this.ticker.read();
        double rate = 0.0;
        if (!this.samples.isEmpty()) {
            Pair<Long, Double> oldestSample = this.samples.peekLast();
            double dy = ((Number)newSample).doubleValue() - oldestSample.getSecond();
            double dt = newTimestamp - oldestSample.getFirst();
            double d = rate = dt == 0.0 ? 0.0 : 1.0E9 * this.scaleFactor * dy / dt;
        }
        if (this.samples.remainingCapacity() == 0) {
            this.samples.removeLast();
        }
        this.samples.addFirst(new Pair<Long, Double>(newTimestamp, ((Number)newSample).doubleValue()));
        return rate;
    }
}

