/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.misc;

public class Statistics {
    private long populationSize = 0L;
    private double accumulatedVariance = 0.0;
    private double runningMean = 0.0;
    private long minValue = Long.MAX_VALUE;
    private long maxValue = Long.MIN_VALUE;

    public void accumulate(long value) {
        ++this.populationSize;
        double delta = (double)value - this.runningMean;
        this.runningMean += delta / (double)this.populationSize;
        this.accumulatedVariance += delta * ((double)value - this.runningMean);
        this.minValue = value < this.minValue ? value : this.minValue;
        this.maxValue = value > this.maxValue ? value : this.maxValue;
    }

    public double variance() {
        return this.accumulatedVariance / (double)this.populationSize;
    }

    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public double mean() {
        return this.runningMean;
    }

    public long min() {
        return this.minValue;
    }

    public long max() {
        return this.maxValue;
    }

    public long range() {
        return this.maxValue - this.minValue;
    }

    public long populationSize() {
        return this.populationSize;
    }

    public String toString() {
        return String.format("Mean: %f, Min: %d, Max: %d, Range: %d, Stddev: %f, Variance: %f", this.mean(), this.min(), this.max(), this.range(), this.standardDeviation(), this.variance());
    }
}

