/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.streaminer.stream.data.Data;
import org.streaminer.stream.learner.LearnerUtils;
import org.streaminer.stream.model.PredictionModel;
import org.streaminer.util.distance.Kernel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperplaneModel
implements PredictionModel<Data, Double> {
    private static final long serialVersionUID = 6049635362534065136L;
    private Kernel kernel;
    Map<String, Double> weights = new LinkedHashMap<String, Double>();
    private double bias;

    public HyperplaneModel(int kernelType) {
        this.kernel = new Kernel(kernelType);
    }

    public void initModel(Map<String, Double> weights, Double bias) {
        this.weights = weights;
        this.bias = bias;
    }

    public Map<String, Double> getWeights() {
        return this.weights;
    }

    public double getBias() {
        return this.bias;
    }

    public void setWeights(Map<String, Double> weights) {
        this.weights = weights;
    }

    public void setBias(double bias) {
        this.bias = bias;
    }

    @Override
    public Double predict(Data item) {
        Map<String, Double> example = LearnerUtils.getNumericVector(item);
        double distance = 0.0;
        distance = this.kernel.getDistance(example, this.weights);
        if ((distance += this.bias) < 0.0) {
            return 0.0;
        }
        return 1.0;
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("Hyperplane:\n\n");
        output.append("bias: " + this.bias + "\n");
        for (String key : this.weights.keySet()) {
            output.append("weight[" + key + "]: " + this.weights.get(key) + "\n");
        }
        return output.toString();
    }
}

