/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.model.Distribution;
import org.streaminer.stream.model.SelectiveDescriptionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NominalDistributionModel<T extends Serializable>
implements SelectiveDescriptionModel<T, Double>,
Distribution<T> {
    private static final long serialVersionUID = -4642672370564928117L;
    static Logger log = LoggerFactory.getLogger(NominalDistributionModel.class);
    Integer count = 0;
    Integer max = Integer.MAX_VALUE;
    Map<T, Integer> counts = new LinkedHashMap<T, Integer>();

    public NominalDistributionModel() {
        this(Integer.MAX_VALUE);
    }

    public NominalDistributionModel(int maxElements) {
        this.max = maxElements;
        this.counts = new LinkedHashMap<T, Integer>();
        this.count = 0;
    }

    @Override
    public Double describe(Serializable parameter) {
        Integer cnt = this.counts.get(parameter);
        if (cnt == null) {
            return 0.0;
        }
        return cnt.doubleValue() / (double)this.count.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(T newVal) {
        if (newVal == null) {
            log.warn("Skipping 'null' value!");
            return;
        }
        Map<T, Integer> map = this.counts;
        synchronized (map) {
            Integer cnt = this.counts.get(newVal);
            cnt = cnt == null ? new Integer(1) : new Integer(cnt + 1);
            this.counts.put(newVal, cnt);
            Integer n = this.count;
            Integer n2 = this.count = Integer.valueOf(this.count + 1);
        }
    }

    @Override
    public Map<T, Double> getHistogram() {
        LinkedHashMap<Serializable, Double> map = new LinkedHashMap<Serializable, Double>();
        for (Serializable key : this.counts.keySet()) {
            map.put(key, this.counts.get(key).doubleValue());
        }
        return map;
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public Set<T> getElements() {
        return this.counts.keySet();
    }

    @Override
    public Integer getCount(T value) {
        Integer cnt = this.counts.get(value);
        if (cnt == null) {
            return 0;
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(int maxElements) {
        log.trace("Truncating distribution to {} elements", (Object)maxElements);
        if (maxElements < 1) {
            this.count = 0;
            this.counts.clear();
            return;
        }
        Map<T, Integer> map = this.counts;
        synchronized (map) {
            ArrayList<T> elements = new ArrayList<T>(this.counts.keySet());
            Collections.sort(elements, new DistributionComparator(this.counts));
            log.trace("Sorted elements: {}", elements);
            int removed = 0;
            int i = 0;
            while (this.counts.size() > maxElements) {
                Integer cnt = this.counts.remove(elements.get(i));
                this.count = this.count - cnt;
                ++removed;
                ++i;
            }
            log.debug("removed {} elements", (Object)removed);
        }
    }

    @Override
    public Double prob(T value) {
        Integer cnt = this.counts.get(value);
        if (cnt == null) {
            return 0.0;
        }
        return cnt.doubleValue() / this.count.doubleValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DistributionComparator
    implements Comparator<T> {
        Map<T, Integer> counts;

        public DistributionComparator(Map<T, Integer> counts) {
            this.counts = counts;
        }

        @Override
        public int compare(T arg0, T arg1) {
            int rc;
            Integer c1;
            Integer c0 = this.counts.get(arg0);
            if (c0 == null) {
                c0 = 0;
            }
            if ((c1 = this.counts.get(arg1)) == null) {
                c1 = 0;
            }
            if ((rc = c0.compareTo(c1)) == 0) {
                return arg0.toString().compareTo(arg1.toString());
            }
            return rc;
        }
    }
}

