/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.model;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.model.Distribution;
import org.streaminer.stream.model.SelectiveDescriptionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericalDistributionModel
implements SelectiveDescriptionModel<Double, Double>,
Distribution<Double> {
    private static final long serialVersionUID = -4642672370564928117L;
    static Logger log = LoggerFactory.getLogger(NumericalDistributionModel.class);
    Integer count = 0;
    Double span = 1.0;
    Double interval = 0.1;
    Double lowerBound = 0.0;
    Integer[] histogram;

    public NumericalDistributionModel(Integer binCount, Double span) {
        this.interval = span / binCount.doubleValue();
        log.info("bin-interval is {}", (Object)this.interval);
        this.histogram = new Integer[binCount.intValue()];
        for (int i = 0; i < this.histogram.length; ++i) {
            this.histogram[i] = 0;
        }
    }

    @Override
    public Double describe(Double parameter) {
        int idx = this.findInterval(parameter);
        return this.histogram[idx].doubleValue();
    }

    @Override
    public void update(Double newVal) {
        Double val = this.normalize(newVal);
        int idx = this.findInterval(val);
        Object object = this.histogram;
        int n = idx;
        Integer n2 = object[n];
        Integer n3 = object[n] = Integer.valueOf(object[n] + 1);
        object = this.count;
        Integer n4 = this.count = Integer.valueOf(this.count + 1);
    }

    protected int findInterval(Double val) {
        for (int i = 0; i < this.histogram.length; ++i) {
            if (!(this.lowerBound + (double)i * this.interval >= val)) continue;
            return Math.max(0, i - 1);
        }
        return this.histogram.length - 1;
    }

    public Double getInterval() {
        return this.interval;
    }

    @Override
    public Set<Double> getElements() {
        TreeSet<Double> el = new TreeSet<Double>();
        for (int i = 0; i < this.histogram.length; ++i) {
            el.add(this.histogram[i].doubleValue());
        }
        return el;
    }

    @Override
    public Map<Double, Double> getHistogram() {
        TreeMap<Double, Double> d = new TreeMap<Double, Double>();
        Double total = this.count.doubleValue();
        if (total == 0.0) {
            total = 1.0;
        }
        for (int i = 0; i < this.histogram.length; ++i) {
            d.put(this.histogram[i].doubleValue(), this.histogram[i].doubleValue() / total);
        }
        return d;
    }

    public Double normalize(Double val) {
        return val / this.span;
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public Double prob(Double value) {
        int i = this.findInterval(value);
        Double cnt = this.histogram[i].doubleValue();
        return cnt / this.count.doubleValue();
    }

    @Override
    public Integer getCount(Double value) {
        int i = this.findInterval(value);
        return this.histogram[i];
    }
}

