/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.streaminer.stream.frequency.FrequencyException;
import org.streaminer.stream.frequency.IRichFrequency;
import org.streaminer.stream.model.Distribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamDistribution<T extends Serializable>
implements Serializable,
Distribution<T> {
    private static final long serialVersionUID = 2696199411688427094L;
    private IRichFrequency<T> counter;

    public StreamDistribution() {
    }

    public StreamDistribution(IRichFrequency<T> countAlgo) {
        this.counter = countAlgo;
    }

    public void setCounter(IRichFrequency<T> counter) {
        this.counter = counter;
    }

    @Override
    public Integer getCount() {
        return (int)this.counter.size();
    }

    @Override
    public Integer getCount(T value) {
        return (int)this.counter.estimateCount(value);
    }

    @Override
    public Map<T, Double> getHistogram() {
        LinkedHashMap<Serializable, Double> hist = new LinkedHashMap<Serializable, Double>();
        for (Serializable key : this.counter.keySet()) {
            hist.put(key, Double.valueOf(this.counter.estimateCount(key)));
        }
        return hist;
    }

    @Override
    public Double prob(T value) {
        Double val = this.counter.estimateCount(value);
        Long total = this.counter.size();
        return val / total.doubleValue();
    }

    @Override
    public void update(T item) {
        try {
            this.counter.add(item);
        }
        catch (FrequencyException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Set<T> getElements() {
        return this.counter.keySet();
    }
}

