/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.norm;

import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.StableRandomGenerator;
import org.streaminer.util.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StableSketch
implements Comparable<StableSketch> {
    private double alpha;
    private int sksize;
    private long seed;
    private double[] sk;
    private RandomGenerator randomGen;
    private StableRandomGenerator stableGen;

    public StableSketch(int sksize, double alpha, long seed) {
        this.alpha = alpha;
        this.sksize = sksize;
        this.seed = seed;
        this.sk = new double[sksize];
        this.randomGen = new MersenneTwister(seed);
        this.stableGen = new StableRandomGenerator(this.randomGen, alpha, 0.0);
    }

    public void add(int item, double val) {
        this.seed = (long)item + this.seed;
        this.randomGen.setSeed(this.seed);
        int j = 0;
        while (j < this.sksize) {
            int n = j++;
            this.sk[n] = this.sk[n] + val * this.stableGen.nextNormalizedDouble();
        }
    }

    public void add(StableSketch that) {
        if (this.compareTo(that) == 0) {
            for (int i = 0; i < this.sksize; ++i) {
                int n = i;
                this.sk[n] = this.sk[n] + that.sk[i];
            }
        }
    }

    public void subtract(StableSketch that) {
        if (this.compareTo(that) == 0) {
            for (int i = 0; i < this.sksize; ++i) {
                int n = i;
                this.sk[n] = this.sk[n] - that.sk[i];
            }
        }
    }

    public double distance(StableSketch that) {
        if (this.compareTo(that) != 0) {
            return -1.0;
        }
        double sum = 0.0;
        double _alpha = this.alpha;
        if (_alpha == 2.0) {
            for (int i = 0; i < this.sksize; ++i) {
                sum += Math.pow(Math.abs(this.sk[i] - that.sk[i]), 2.0);
            }
        } else {
            double[] holder = new double[this.sksize + 1];
            for (int i = 0; i < this.sksize; ++i) {
                holder[i + 1] = this.sk[i] - that.sk[i];
            }
            sum = ArrayUtils.doubleMedSelect(this.sksize / 2, this.sksize, holder);
        }
        return sum;
    }

    public double norm() {
        double sum = 0.0;
        if (this.alpha == 2.0) {
            for (int i = 0; i < this.sksize; ++i) {
                double est = this.sk[i] * this.sk[i];
                sum += est;
            }
            sum = Math.pow(sum / (double)this.sksize, 0.5);
        } else {
            double[] holder = new double[this.sksize + 1];
            for (int i = 0; i < this.sksize; ++i) {
                holder[i + 1] = Math.abs(this.sk[i]);
            }
            sum = ArrayUtils.doubleMedSelect(this.sksize / 2, this.sksize, holder);
            sum = this.alpha < 0.01 ? Math.pow(sum, 0.02) : Math.pow(sum, this.alpha);
        }
        return sum;
    }

    @Override
    public int compareTo(StableSketch that) {
        if (this.alpha != that.alpha || this.sksize != that.sksize || this.seed != that.seed) {
            return 1;
        }
        return 0;
    }
}

