/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.quantile;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import org.streaminer.stream.quantile.GKQuantiles;
import org.streaminer.stream.quantile.IQuantiles;
import org.streaminer.stream.quantile.QuantilesException;
import org.streaminer.util.distance.CosineDistance;
import org.streaminer.util.distance.LinearDistance;
import org.streaminer.util.distance.SquaredDistance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnsembleQuantiles
implements IQuantiles<Double> {
    private GKQuantiles activeBlock;
    private LinkedList<Double> sampleBlock;
    private int chunkSize;
    private int maxEnsembleSize;
    private double sampleRatio;
    private LinkedList<SingleModel> ensemble;
    private String updateMode;
    private String similarityMeasure;
    private double epsilon;
    public static final String REPLACE_OLDEST_MODEL = "replaceOldest";
    public static final String REPLACE_MOST_DISSIMILAR_MODEL = "replaceMostDissimilar";
    public static final String REPLACE_RANDOM_MODEL = "replaceRandom";
    public static final String REPLACE_SAMPLED_MOST_DISSIMILAR_MODEL = "replaceSampledMostDissimilar";
    public static final String MERGE_OLDEST_MODELS = "mergeOldest";
    public static final String MERGE_MOST_SIMILAR_MODELS = "mergeMostSimilar";
    public static final String MERGE_MOST_DISSIMILAR_MODELS = "mergeMostDissimilar";
    public static final String MERGE_ROUND_ROBIN = "mergeRoundRobin";
    public static final String EUCLIDEAN_DISTANCE = "euclidean distance";
    public static final String COSINE_DISTANCE = "cosine distance";
    public static final String MANHATTAN_DISTANCE = "manhattan distance";

    public EnsembleQuantiles() {
        this(0.01f);
    }

    public EnsembleQuantiles(double epsilon) {
        if (epsilon <= 0.0 || epsilon >= 1.0) {
            throw new RuntimeException("An appropriate epsilon value must lay between 0 and 1.");
        }
        this.epsilon = epsilon;
        this.activeBlock = new GKQuantiles(epsilon);
        this.sampleBlock = new LinkedList();
        this.ensemble = new LinkedList();
        this.setChunkSize(250000);
        this.setEnsembleSize(5);
        this.updateMode = REPLACE_MOST_DISSIMILAR_MODEL;
        this.sampleRatio = 0.5;
        this.similarityMeasure = EUCLIDEAN_DISTANCE;
    }

    public void setEpsilon(Double epsilon) {
        this.epsilon = epsilon;
        this.activeBlock = new GKQuantiles(epsilon);
        this.sampleBlock = new LinkedList();
        this.ensemble = new LinkedList();
    }

    @Override
    public void offer(Double value) {
        this.activeBlock.offer(value);
        if (this.updateMode.equals(REPLACE_SAMPLED_MOST_DISSIMILAR_MODEL) && this.addToSampleBlock()) {
            this.sampleBlock.addLast(value);
            if (this.sampleBlock.size() > this.chunkSize) {
                this.sampleBlock.removeFirst();
            }
        }
        if (this.activeBlock.getCount() == this.chunkSize) {
            this.updateEnsemble();
            this.activeBlock = new GKQuantiles(this.epsilon);
        }
    }

    @Override
    public Double getQuantile(double q) throws QuantilesException {
        LinkedList<Double> summary = this.getSummary();
        Double wantedRank = Math.floor(q * (double)summary.size());
        try {
            return summary.get(wantedRank.intValue());
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public void setChunkSize(Integer chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setEnsembleSize(Integer maxEnsembleSize) {
        this.maxEnsembleSize = maxEnsembleSize;
        while (this.ensemble.size() > maxEnsembleSize) {
            this.ensemble.removeFirst();
        }
    }

    public int getEnsembleSize() {
        return this.maxEnsembleSize;
    }

    public String getUpdateMode() {
        return this.updateMode;
    }

    public void setUpdateMode(String um) {
        String updateMode = um;
        if (um.indexOf("_") > 0) {
            String[] tok = um.split("_");
            String mode = tok[0].toLowerCase();
            for (int i = 1; i < tok.length; ++i) {
                String cur = tok[i].toLowerCase();
                mode = mode + cur.substring(0, 1).toUpperCase() + cur.substring(1);
            }
            updateMode = mode;
        }
        if (updateMode.equals(REPLACE_OLDEST_MODEL) || updateMode.equals(REPLACE_RANDOM_MODEL) || updateMode.equals(REPLACE_MOST_DISSIMILAR_MODEL) || updateMode.equals(REPLACE_SAMPLED_MOST_DISSIMILAR_MODEL) || updateMode.equals(MERGE_OLDEST_MODELS) || updateMode.equals(MERGE_MOST_SIMILAR_MODELS) || updateMode.equals(MERGE_MOST_DISSIMILAR_MODELS) || updateMode.equals(MERGE_ROUND_ROBIN)) {
            this.updateMode = updateMode;
        }
    }

    public double getSampleRatio() {
        return this.sampleRatio;
    }

    public void setSampleRatio(Double sampleRatio) {
        if (sampleRatio < 0.0) {
            sampleRatio = 0.0;
        }
        if (sampleRatio > 1.0) {
            sampleRatio = 1.0;
        }
        this.sampleRatio = sampleRatio;
    }

    public void setSimilarityMeasure(String similarityMeasure) {
        if (similarityMeasure.equals(COSINE_DISTANCE) || similarityMeasure.equals(EUCLIDEAN_DISTANCE) || similarityMeasure.equals(MANHATTAN_DISTANCE)) {
            this.similarityMeasure = similarityMeasure;
        }
    }

    public String getSimilarityMeasure() {
        return this.similarityMeasure;
    }

    private void updateEnsemble() {
        SingleModel newModel = this.getNewModel();
        if (this.ensemble.size() < this.maxEnsembleSize) {
            this.ensemble.addLast(newModel);
        } else {
            if (this.updateMode.equals(MERGE_ROUND_ROBIN)) {
                this.mergeRoundRobinModels(newModel);
                return;
            }
            if (this.updateMode.equals(REPLACE_OLDEST_MODEL)) {
                this.replaceOldestModel(newModel);
            }
            if (this.updateMode.equals(REPLACE_RANDOM_MODEL)) {
                this.replaceRandomModel(newModel);
            }
            if (this.updateMode.equals(REPLACE_MOST_DISSIMILAR_MODEL)) {
                this.replaceMostDissimilarModel(newModel);
            }
            if (this.updateMode.equals(REPLACE_SAMPLED_MOST_DISSIMILAR_MODEL)) {
                this.replaceSampledMostDissimilarModel(newModel);
            }
            if (this.updateMode.equals(MERGE_OLDEST_MODELS)) {
                this.mergeOldestModels(newModel);
            }
            if (this.updateMode.equals(MERGE_MOST_SIMILAR_MODELS)) {
                this.mergeMostSimilarModels(newModel);
            }
            if (this.updateMode.equals(MERGE_MOST_DISSIMILAR_MODELS)) {
                this.mergeMostDissimilarModels(newModel);
            }
        }
    }

    private void replaceOldestModel(SingleModel newModel) {
        this.ensemble.removeFirst();
        this.ensemble.addLast(newModel);
    }

    private void replaceRandomModel(SingleModel newModel) {
        Random random = new Random();
        this.ensemble.remove(random.nextInt(this.ensemble.size()));
        this.ensemble.addLast(newModel);
    }

    private void replaceMostDissimilarModel(SingleModel newModel) {
        SingleModel worstModel = this.getModelWithLowestSimilarityTo(newModel);
        this.ensemble.remove(worstModel);
        this.ensemble.addLast(newModel);
    }

    private void replaceSampledMostDissimilarModel(SingleModel newModel) {
        LinkedList<Double> quantiles = new LinkedList<Double>();
        Double phi = this.epsilon;
        while (phi < 1.0) {
            Double nextQuantile = phi * (double)this.sampleBlock.size();
            try {
                quantiles.add(this.sampleBlock.get(nextQuantile.intValue()));
            }
            catch (IndexOutOfBoundsException e) {
                phi = 1.0;
                quantiles = newModel.getQuantiles();
            }
            phi = phi + this.epsilon;
        }
        SingleModel sample = new SingleModel(quantiles);
        SingleModel worstModel = this.getModelWithLowestSimilarityTo(sample);
        this.ensemble.remove(worstModel);
        this.ensemble.addLast(newModel);
    }

    private void mergeOldestModels(SingleModel newModel) {
        SingleModel mergedModel = this.mergeModels(this.ensemble.get(0), this.ensemble.get(1));
        this.ensemble.removeFirst();
        this.ensemble.removeFirst();
        this.ensemble.addFirst(mergedModel);
        this.ensemble.addLast(newModel);
    }

    private void mergeRoundRobinModels(SingleModel newModel) {
        SingleModel mergedModel = this.mergeModels(this.ensemble.get(0), this.ensemble.get(1));
        this.ensemble.removeFirst();
        this.ensemble.removeFirst();
        this.ensemble.addLast(mergedModel);
        this.ensemble.addLast(newModel);
    }

    private void mergeMostSimilarModels(SingleModel newModel) {
        LinkedList<LinkedList<Double>> allModels = new LinkedList<LinkedList<Double>>();
        for (int i = 0; i < this.ensemble.size(); ++i) {
            allModels.add(this.ensemble.get(i).getQuantiles());
        }
        LinkedList mergePair = (LinkedList)SquaredDistance.getPairWithSmallestDistance(allModels);
        if (this.similarityMeasure.equals(COSINE_DISTANCE)) {
            mergePair = (LinkedList)CosineDistance.getPairWithSmallestDistance(allModels);
        }
        if (this.similarityMeasure.equals(MANHATTAN_DISTANCE)) {
            mergePair = (LinkedList)LinearDistance.getPairWithSmallestDistance(allModels);
        }
        SingleModel mergedOne = new SingleModel((LinkedList)mergePair.getFirst());
        SingleModel mergedTwo = new SingleModel((LinkedList)mergePair.getLast());
        SingleModel mergedModel = this.mergeModels(mergedOne, mergedTwo);
        Iterator it = this.ensemble.iterator();
        while (it.hasNext()) {
            SingleModel cur = (SingleModel)it.next();
            if (!cur.equals(mergedOne) && !cur.equals(mergedTwo)) continue;
            it.remove();
        }
        this.ensemble.add(mergedModel);
        this.ensemble.add(newModel);
    }

    private void mergeMostDissimilarModels(SingleModel newModel) {
        LinkedList<LinkedList<Double>> allModels = new LinkedList<LinkedList<Double>>();
        for (int i = 0; i < this.ensemble.size(); ++i) {
            allModels.add(this.ensemble.get(i).getQuantiles());
        }
        LinkedList mergePair = (LinkedList)SquaredDistance.getPairWithFurthestDistance(allModels);
        if (this.similarityMeasure.equals(COSINE_DISTANCE)) {
            mergePair = (LinkedList)CosineDistance.getPairWithFurthestDistance(allModels);
        }
        if (this.similarityMeasure.equals(MANHATTAN_DISTANCE)) {
            mergePair = (LinkedList)LinearDistance.getPairWithFurthestDistance(allModels);
        }
        SingleModel mergedOne = new SingleModel((LinkedList)mergePair.getFirst());
        SingleModel mergedTwo = new SingleModel((LinkedList)mergePair.getLast());
        SingleModel mergedModel = this.mergeModels(mergedOne, mergedTwo);
        for (int i = 0; i < this.ensemble.size(); ++i) {
            if (!this.ensemble.get(i).equals(mergedOne) && !this.ensemble.get(i).equals(mergedTwo)) continue;
            this.ensemble.remove(i);
        }
        this.ensemble.add(mergedModel);
        this.ensemble.add(newModel);
    }

    private SingleModel getNewModel() {
        LinkedList<Double> quantiles = new LinkedList<Double>();
        Double phi = this.epsilon;
        while (phi < 1.0) {
            quantiles.add(this.activeBlock.getQuantile(phi));
            phi = phi + this.epsilon;
        }
        return new SingleModel(quantiles);
    }

    private SingleModel getModelWithLowestSimilarityTo(SingleModel comparator) {
        LinkedList<LinkedList<Double>> oldQuantiles = new LinkedList<LinkedList<Double>>();
        for (int i = 0; i < this.ensemble.size(); ++i) {
            oldQuantiles.add(this.ensemble.get(i).getQuantiles());
        }
        LinkedList<Double> toBeRemovedQuantiles = SquaredDistance.getFarestVector(oldQuantiles, comparator.getQuantiles());
        if (this.similarityMeasure.equals(COSINE_DISTANCE)) {
            toBeRemovedQuantiles = CosineDistance.getFarestVector(oldQuantiles, comparator.getQuantiles());
        }
        if (this.similarityMeasure.equals(MANHATTAN_DISTANCE)) {
            toBeRemovedQuantiles = LinearDistance.getFarestVector(oldQuantiles, comparator.getQuantiles());
        }
        SingleModel toBeRemoved = new SingleModel(toBeRemovedQuantiles);
        for (int i = 0; i < this.ensemble.size(); ++i) {
            if (!this.ensemble.get(i).equals(toBeRemoved)) continue;
            return this.ensemble.get(i);
        }
        return toBeRemoved;
    }

    private boolean addToSampleBlock() {
        Random random = new Random();
        return random.nextDouble() <= this.sampleRatio;
    }

    private SingleModel mergeModels(SingleModel first, SingleModel second) {
        LinkedList<Double> fst = first.getQuantiles();
        LinkedList<Double> snd = second.getQuantiles();
        LinkedList<Double> merged = new LinkedList<Double>();
        for (int i = 0; i < fst.size() && i < snd.size(); ++i) {
            merged.add(0.5 * (fst.get(i) + snd.get(i)));
        }
        return new SingleModel(merged);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.getClass().getCanonicalName());
        s.append(" {");
        s.append(" updateMode=" + this.getUpdateMode());
        s.append(", epsilon=" + this.epsilon);
        s.append(", chunkSize=" + this.getChunkSize());
        s.append(", ensembleSize=" + this.getEnsembleSize());
        s.append(" }");
        return s.toString();
    }

    private LinkedList<Double> getSummary() {
        LinkedList<Double> summary = new LinkedList<Double>();
        for (int i = 0; i < this.ensemble.size(); ++i) {
            summary.addAll(this.ensemble.get(i).getQuantiles());
        }
        Double phi = this.epsilon;
        if ((double)this.activeBlock.getCount().intValue() > 1.0 / this.epsilon) {
            while (phi < 1.0) {
                summary.add(this.activeBlock.getQuantile(phi));
                phi = phi + this.epsilon;
            }
        }
        while (summary.contains(null)) {
            summary.remove(null);
        }
        Collections.sort(summary);
        return summary;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SingleModel
    implements Serializable {
        private static final long serialVersionUID = -8462870855147396071L;
        private LinkedList<Double> quantiles;

        public SingleModel(LinkedList<Double> quantiles) {
            this.quantiles = quantiles;
        }

        public LinkedList<Double> getQuantiles() {
            return this.quantiles;
        }

        public boolean equals(SingleModel model) {
            for (int i = 0; i < this.quantiles.size(); ++i) {
                if (this.quantiles.get(i).equals(model.getQuantiles().get(i))) continue;
                return false;
            }
            return true;
        }
    }
}

