/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.quantile;

import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.streaminer.stream.quantile.IQuantiles;
import org.streaminer.stream.quantile.QuantilesException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExactQuantiles
implements IQuantiles<Double> {
    private Map<Double, Long> elements;
    private long overallCount = 0L;
    private TreeSet<Double> data = new TreeSet();

    public ExactQuantiles() {
        this.elements = new ConcurrentHashMap<Double, Long>();
    }

    @Override
    public void offer(Double value) {
        Long count = this.elements.get(value);
        if (count == null) {
            this.elements.put(value, new Long(1L));
            this.data.add(value);
        } else {
            this.elements.put(value, count + 1L);
        }
        ++this.overallCount;
    }

    @Override
    public Double getQuantile(double q) throws QuantilesException {
        long overallCountCopy = new Long(this.overallCount);
        long rank = (long)Math.floor(q * (double)overallCountCopy);
        long countSum = 0L;
        for (Double val : this.data) {
            Long count = this.elements.get(val);
            if (rank > (countSum += count.longValue())) continue;
            return val;
        }
        return Double.NaN;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.getClass().getCanonicalName());
        s.append(" {");
        s.append(" }");
        return s.toString();
    }
}

