/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.quantile;

import java.util.Random;
import org.streaminer.stream.quantile.IQuantiles;
import org.streaminer.stream.quantile.QuantilesException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frugal2U
implements IQuantiles<Integer> {
    private final Quantile[] quantiles;

    public Frugal2U(Quantile[] quantiles) {
        this.quantiles = quantiles;
    }

    public Frugal2U(double[] quantiles, int initialEstimate) {
        this.quantiles = new Quantile[quantiles.length];
        for (int i = 0; i < quantiles.length; ++i) {
            this.quantiles[i] = new Quantile(initialEstimate, quantiles[i]);
        }
    }

    @Override
    public void offer(Integer value) {
        for (Quantile q : this.quantiles) {
            q.insert(value);
        }
    }

    @Override
    public Integer getQuantile(double q) throws QuantilesException {
        for (Quantile quantile : this.quantiles) {
            if (quantile.q != q) continue;
            return quantile.m;
        }
        return 0;
    }

    public class Quantile {
        int m;
        double q;
        int step = 1;
        int sign = 0;
        Random r = new Random(new Random().nextInt());

        Quantile(int estimate, double quantile) {
            this.m = estimate;
            this.q = quantile;
        }

        void insert(int s) {
            if (this.sign == 0) {
                this.m = s;
                this.sign = 1;
                return;
            }
            double rnd = this.r.nextDouble();
            if (s > this.m && rnd > 1.0 - this.q) {
                this.step += this.sign * this.f(this.step);
                this.m = this.step > 0 ? (this.m += this.step) : ++this.m;
                if (this.m > s) {
                    this.step += s - this.m;
                    this.m = s;
                }
                if (this.sign < 0 && this.step > 1) {
                    this.step = 1;
                }
                this.sign = 1;
            } else if (s < this.m && rnd > this.q) {
                this.step += -this.sign * this.f(this.step);
                this.m = this.step > 0 ? (this.m -= this.step) : --this.m;
                if (this.m < s) {
                    this.step += this.m - s;
                    this.m = s;
                }
                if (this.sign > 0 && this.step > 1) {
                    this.step = 1;
                }
                this.sign = -1;
            }
        }

        int f(int step) {
            return 1;
        }
    }
}

