/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.quantile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.streaminer.stream.quantile.IQuantiles;
import org.streaminer.stream.quantile.QuantilesException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPQuantiles
implements IQuantiles<Double> {
    private static final long MAX_TOT_ELEMS = 0x10000000000L;
    private final List<List<Double>> buffer = new ArrayList<List<Double>>();
    private final int maxElementsPerBuffer;
    private final int numQuantiles;
    private int totalElements;
    private double min;
    private double max;

    public MPQuantiles(int numQuantiles) {
        this.numQuantiles = Math.max(2, numQuantiles);
        this.maxElementsPerBuffer = this.computeMaxElementsPerBuffer();
    }

    @Override
    public void offer(Double value) {
        if (this.totalElements == 0 || value < this.min) {
            this.min = value;
        }
        if (this.totalElements == 0 || this.max < value) {
            this.max = value;
        }
        if (this.totalElements > 0 && this.totalElements % (2 * this.maxElementsPerBuffer) == 0) {
            Collections.sort(this.buffer.get(0));
            Collections.sort(this.buffer.get(1));
            this.recursiveCollapse(this.buffer.get(0), 1);
        }
        this.ensureBuffer(0);
        this.ensureBuffer(1);
        int index = this.buffer.get(0).size() < this.maxElementsPerBuffer ? 0 : 1;
        this.buffer.get(index).add(value);
        ++this.totalElements;
    }

    @Override
    public Double getQuantile(double q) throws QuantilesException {
        double quantileKey = 0.0;
        for (double quantileValue : this.getQuantiles()) {
            if (MPQuantiles.round(quantileKey) == q) {
                return quantileValue;
            }
            quantileKey += 1.0 / (double)(this.numQuantiles - 1);
        }
        return 0.0;
    }

    public void clear() {
        this.buffer.clear();
        this.totalElements = 0;
    }

    public Map<Double, Double> getFullQuantiles() {
        HashMap<Double, Double> quantiles = new HashMap<Double, Double>();
        double quantileKey = 0.0;
        for (double quantileValue : this.getQuantiles()) {
            quantiles.put(MPQuantiles.round(quantileKey), quantileValue);
            quantileKey += 1.0 / (double)(this.numQuantiles - 1);
        }
        return quantiles;
    }

    public List<Double> getQuantiles() {
        ArrayList<Double> quantiles = new ArrayList<Double>();
        quantiles.add(this.min);
        if (this.buffer.get(0) != null) {
            Collections.sort(this.buffer.get(0));
        }
        if (this.buffer.get(1) != null) {
            Collections.sort(this.buffer.get(1));
        }
        int[] index = new int[this.buffer.size()];
        long S = 0L;
        for (int i = 1; i <= this.numQuantiles - 2; ++i) {
            double smallest;
            long targetS = (long)Math.ceil((double)i * ((double)this.totalElements / ((double)this.numQuantiles - 1.0)));
            while (true) {
                long incrementS;
                smallest = this.max;
                int minBufferId = -1;
                for (int j = 0; j < this.buffer.size(); ++j) {
                    if (this.buffer.get(j) == null || index[j] >= this.buffer.get(j).size() || smallest < this.buffer.get(j).get(index[j])) continue;
                    smallest = this.buffer.get(j).get(index[j]);
                    minBufferId = j;
                }
                long l = incrementS = minBufferId <= 1 ? 1L : 1L << minBufferId - 1;
                if (S + incrementS >= targetS) break;
                int n = minBufferId;
                index[n] = index[n] + 1;
                S += incrementS;
            }
            quantiles.add(smallest);
        }
        quantiles.add(this.max);
        return quantiles;
    }

    private int computeMaxElementsPerBuffer() {
        double epsilon = 1.0 / ((double)this.numQuantiles - 1.0);
        int b = 2;
        while ((double)((long)(b - 2) * (1L << b - 2)) + 0.5 <= epsilon * 1.099511627776E12) {
            ++b;
        }
        return (int)(0x10000000000L / (1L << b - 1));
    }

    private void ensureBuffer(int level) {
        while (this.buffer.size() < level + 1) {
            this.buffer.add(null);
        }
        if (this.buffer.get(level) == null) {
            this.buffer.set(level, new ArrayList());
        }
    }

    private void collapse(List<Double> a, List<Double> b, List<Double> out) {
        int indexA = 0;
        int indexB = 0;
        int count = 0;
        Double smaller = null;
        while (indexA < this.maxElementsPerBuffer || indexB < this.maxElementsPerBuffer) {
            smaller = indexA >= this.maxElementsPerBuffer || indexB < this.maxElementsPerBuffer && a.get(indexA) >= b.get(indexB) ? b.get(indexB++) : a.get(indexA++);
            if (count++ % 2 != 0) continue;
            out.add(smaller);
        }
        a.clear();
        b.clear();
    }

    private void recursiveCollapse(List<Double> buf, int level) {
        this.ensureBuffer(level + 1);
        List<Object> merged = this.buffer.get(level + 1).isEmpty() ? this.buffer.get(level + 1) : new ArrayList(this.maxElementsPerBuffer);
        this.collapse(this.buffer.get(level), buf, merged);
        if (this.buffer.get(level + 1) != merged) {
            this.recursiveCollapse(merged, level + 1);
        }
    }

    private static double round(double d) {
        return (double)Math.round(d * 100000.0) / 100000.0;
    }
}

