/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.quantile;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArrayList;
import org.streaminer.stream.quantile.IQuantiles;
import org.streaminer.stream.quantile.QuantilesException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleQuantiles
implements IQuantiles<Double> {
    private boolean initialPhase;
    private Integer bufferSize;
    private CopyOnWriteArrayList<Double> buffer;
    private double epsilon;

    public SimpleQuantiles(double epsilon) {
        if (epsilon <= 0.0 || epsilon >= 1.0) {
            throw new RuntimeException("An appropriate epsilon value must lay between 0 and 1.");
        }
        this.epsilon = epsilon;
        this.bufferSize = this.computeBufferSize();
        this.initialPhase = true;
        this.buffer = new CopyOnWriteArrayList();
    }

    @Override
    public void offer(Double value) {
        this.buffer.add(value);
        if (this.buffer.size() >= this.bufferSize) {
            this.initialPhase = false;
            this.buffer.remove(0);
        }
    }

    @Override
    public Double getQuantile(double q) throws QuantilesException {
        if (this.buffer.size() != this.bufferSize.intValue()) {
            if (this.bufferSize == 0) {
                return Double.NaN;
            }
            return this.buffer.get((int)Math.floor(q * (double)this.buffer.size()));
        }
        Integer lowerBound = this.computeLowerBound(q);
        Integer upperBound = this.computeUpperBound(q);
        LinkedList<Double> copyOfBuffer = new LinkedList<Double>();
        Iterator<Double> tempBuffer = this.buffer.iterator();
        while (tempBuffer.hasNext()) {
            copyOfBuffer.add(tempBuffer.next());
        }
        Collections.sort(copyOfBuffer);
        return (Double)copyOfBuffer.get((int)Math.floor(lowerBound + upperBound) / 2);
    }

    public boolean isInInitialPhase() {
        return this.initialPhase;
    }

    private int computeBufferSize() {
        Double temp = Math.ceil(9.0 / (this.epsilon * (1.0 - this.epsilon)));
        return temp.intValue();
    }

    private Integer computeLowerBound(double phi) {
        double p = 1.0 - (1.0 - this.epsilon) / 2.0;
        if (this.epsilon < 0.5) {
            p = 1.0 - this.epsilon / 2.0;
        }
        double t = Math.sqrt(-2.0 * Math.log(1.0 - p));
        double gaussianPQuantile = t - (2.515517 + 0.802853 * t + 0.010328 * Math.pow(t, 2.0)) / (1.0 + 1.432788 * t + 0.189269 * Math.pow(t, 2.0) + 0.001308 * Math.pow(t, 3.0));
        Double bound = 1.0;
        bound = Math.ceil((double)this.bufferSize.intValue() * phi - gaussianPQuantile * Math.sqrt((double)this.bufferSize.intValue() * phi * (1.0 - phi)));
        if (bound <= 0.0) {
            bound = 1.0;
        }
        return bound.intValue();
    }

    private Integer computeUpperBound(double phi) {
        double p = 1.0 - (1.0 - this.epsilon) / 2.0;
        if (this.epsilon < 0.5) {
            p = 1.0 - this.epsilon / 2.0;
        }
        double t = Math.sqrt(-2.0 * Math.log(1.0 - p));
        double gaussianPQuantile = t - (2.515517 + 0.802853 * t + 0.010328 * Math.pow(t, 2.0)) / (1.0 + 1.432788 * t + 0.189269 * Math.pow(t, 2.0) + 0.001308 * Math.pow(t, 3.0));
        Double bound = 1.0;
        bound = Math.ceil((double)this.bufferSize.intValue() * phi + gaussianPQuantile * Math.sqrt((double)this.bufferSize.intValue() * phi * (1.0 - phi)));
        if (bound >= (double)this.bufferSize.intValue()) {
            bound = 1.0;
        }
        return bound.intValue();
    }
}

