/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.quantile;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.streaminer.stream.quantile.IQuantiles;
import org.streaminer.stream.quantile.QuantilesException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SumQuantiles
implements IQuantiles<Double>,
Serializable {
    private static final long serialVersionUID = 7331604622548281844L;
    private int slidingWindowSize = 5000;
    private int maxBucketCount = 10;
    private int elementPerBucket = this.slidingWindowSize / this.maxBucketCount;
    private int biggestSeenElement = 0;
    private Bucket newestBucket = null;
    private List<Bucket> buckets;

    public SumQuantiles(int slidingWindowSize, int bucketCount) {
        this.slidingWindowSize = slidingWindowSize;
        this.maxBucketCount = bucketCount;
        this.elementPerBucket = slidingWindowSize / this.maxBucketCount;
        this.buckets = new CopyOnWriteArrayList<Bucket>();
        this.addNewBucket();
    }

    @Override
    public void offer(Double value) {
        this.biggestSeenElement = Math.max(this.biggestSeenElement, value.intValue());
        this.newestBucket.learn(value);
        if (this.newestBucket.isFull()) {
            this.addNewBucket();
        }
    }

    @Override
    public Double getQuantile(double q) throws QuantilesException {
        int overallElementCount = 0;
        for (Bucket bucket : this.buckets) {
            overallElementCount += bucket.getElementCount();
        }
        int wantedRank = (int)((double)overallElementCount * q);
        int sum = 0;
        for (int i = 0; i < this.biggestSeenElement; ++i) {
            long predict = this.getAllBucketPrediction(i);
            if ((sum = (int)((long)sum + predict)) < wantedRank) continue;
            return i;
        }
        return 0.0;
    }

    private void addNewBucket() {
        Bucket newBucket = new Bucket();
        this.buckets.add(newBucket);
        this.newestBucket = newBucket;
        this.deleteExcessiveBuckets();
    }

    private void deleteExcessiveBuckets() {
        while (this.buckets.size() > this.maxBucketCount) {
            this.buckets.remove(0);
        }
    }

    private int getAllBucketPrediction(int item) {
        int prediction = 0;
        for (Bucket bucket : this.buckets) {
            prediction = (int)((long)prediction + bucket.predict(item));
        }
        return prediction;
    }

    private class Bucket
    implements Serializable {
        private static final long serialVersionUID = -2211156505869843563L;
        private int elementCount = 0;
        private Map<String, Integer> counterMap = new ConcurrentHashMap<String, Integer>();

        public long predict(int item) {
            String asString = Integer.valueOf(item).toString();
            if (this.counterMap.containsKey(asString)) {
                return this.counterMap.get(asString).intValue();
            }
            return 0L;
        }

        public void learn(Double item) {
            int value = item.intValue();
            String asString = Integer.valueOf(value).toString();
            if (this.counterMap.containsKey(asString)) {
                int counter = this.counterMap.get(asString);
                this.counterMap.put(asString, ++counter);
            } else {
                this.counterMap.put(asString, 1);
            }
            ++this.elementCount;
        }

        public int getElementCount() {
            return this.elementCount;
        }

        public boolean isFull() {
            return this.elementCount >= SumQuantiles.this.elementPerBucket;
        }

        public String toString() {
            System.out.println("--------------------------------------");
            String out = "Bucket: \n";
            for (String key : this.counterMap.keySet()) {
                out = out + key + "  " + this.counterMap.get(key) + "\n";
            }
            return out;
        }
    }
}

