/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.quantile;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import org.streaminer.stream.model.SlidingWindow;
import org.streaminer.stream.quantile.GKQuantiles;
import org.streaminer.stream.quantile.IQuantiles;
import org.streaminer.stream.quantile.QuantilesException;
import org.streaminer.util.math.PowerOfTwo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowSketchQuantiles
implements IQuantiles<Double>,
Serializable {
    private static final long serialVersionUID = 8629450116663341157L;
    private Long elementCount;
    private int windowSize;
    private int maxLevel;
    private GKQuantiles initialGK;
    private LinkedList<Block> levels = new LinkedList();
    private LinkedList<SlidingWindow<Quantiles>> quantiles;
    protected double epsilon;

    public WindowSketchQuantiles(double epsilon) {
        if (epsilon <= 0.0 || epsilon >= 1.0) {
            throw new RuntimeException("An appropriate epsilon value must lay between 0 and 1.");
        }
        this.initialGK = new GKQuantiles(epsilon);
        this.quantiles = new LinkedList();
        this.elementCount = 0L;
        this.setWindowSize(32768);
        Double value = 1.0 / epsilon;
        this.epsilon = 1.0 / PowerOfTwo.floorToNext(value);
        this.prepareLevels();
    }

    @Override
    public void offer(Double value) {
        this.incrementCount();
        this.insertElement(value);
        if (this.elementCount < (long)this.windowSize) {
            this.initialGK.offer(value);
        }
        this.slideWindow();
    }

    @Override
    public Double getQuantile(double q) throws QuantilesException {
        if (this.elementCount < (long)this.windowSize) {
            return this.initialGK.getQuantile(q);
        }
        LinkedList<Double> summary = this.getFinalSummary();
        Double rank = q * (double)summary.size();
        Double quantile = summary.get(rank.intValue());
        return quantile;
    }

    private void prepareLevels() {
        this.computeMaximumLevel();
        Double blockSize = this.computeMinBlockSize();
        Float levelEpsilon = this.computeEpsilonForMinLevel();
        for (int i = 0; i < this.maxLevel + 1; ++i) {
            Block newBlock = new Block(levelEpsilon, blockSize.intValue());
            this.levels.addLast(newBlock);
            blockSize = blockSize * 2.0;
            levelEpsilon = Float.valueOf(levelEpsilon.floatValue() / 2.0f);
            SlidingWindow newWindow = new SlidingWindow(this.windowSize);
            this.quantiles.add(newWindow);
        }
    }

    private void computeMaximumLevel() {
        Double maxLevel = Math.log10(4.0 / this.epsilon) / Math.log10(2.0);
        this.maxLevel = maxLevel.intValue();
    }

    private Float computeEpsilonForMinLevel() {
        int divisor = 2 * (2 * this.maxLevel + 2);
        Double epsilon = this.epsilon * Math.pow(2.0, this.maxLevel) / (double)divisor;
        return Float.valueOf(epsilon.floatValue());
    }

    private Double computeMinBlockSize() {
        Double minBlockSize = this.epsilon * (double)this.windowSize;
        return minBlockSize / 4.0;
    }

    public final void setWindowSize(int windowSize) {
        if ((windowSize = PowerOfTwo.ceilToNext(windowSize)) <= 128) {
            return;
        }
        this.quantiles = new LinkedList();
        this.elementCount = 0L;
        this.windowSize = windowSize;
        this.prepareLevels();
    }

    private void insertElement(Double item) {
        for (int i = 0; i < this.maxLevel + 1; ++i) {
            this.levels.get(i).insert(item);
            if (this.elementCount % (long)this.levels.get(i).getBlockSize().intValue() != 0L) continue;
            Quantiles newQuantiles = new Quantiles(this.levels.get(i).getEpsilon(), this.levels.get(i).getSummary());
            this.quantiles.get(i).add(newQuantiles, this.levels.get(i).getBlockSize());
        }
    }

    private void incrementCount() {
        WindowSketchQuantiles windowSketchQuantiles = this;
        Long l = windowSketchQuantiles.elementCount;
        Long l2 = windowSketchQuantiles.elementCount = Long.valueOf(windowSketchQuantiles.elementCount + 1L);
    }

    private LinkedList<Quantiles> getStreamSummary() {
        int i;
        int level;
        LinkedList<Quantiles> summary = new LinkedList<Quantiles>();
        if (!this.quantiles.get(this.maxLevel).isEmpty()) {
            summary.add(this.quantiles.get(this.maxLevel).getNewestElement());
            return summary;
        }
        Quantiles bigBlock = this.quantiles.get(this.maxLevel - 1).getNewestElement();
        int leftBorder = this.quantiles.get(this.maxLevel - 1).getLifeTime(0);
        int rightBorder = this.quantiles.get(this.maxLevel - 1).getLifeTime(0) + this.quantiles.get(this.maxLevel - 1).getSize(0);
        int maxUncovered = this.quantiles.get(0).getSize(0);
        for (level = this.maxLevel - 2; level >= 0 && leftBorder > maxUncovered; --level) {
            for (i = this.quantiles.get(level).getAll().size() - 1; i > -1; --i) {
                if (leftBorder <= this.quantiles.get(level).getLifeTime(i)) continue;
                leftBorder = this.quantiles.get(level).getLifeTime(i);
                summary.addFirst(this.quantiles.get(level).get(i));
            }
        }
        summary.add(bigBlock);
        for (level = this.maxLevel - 2; level >= 0 && rightBorder < this.windowSize - maxUncovered; --level) {
            for (i = 0; i < this.quantiles.get(level).getAll().size(); ++i) {
                if (rightBorder >= this.quantiles.get(level).getLifeTime(i) + this.quantiles.get(level).getSize(i)) continue;
                rightBorder = this.quantiles.get(level).getLifeTime(i) + this.quantiles.get(level).getSize(i);
                summary.addLast(this.quantiles.get(level).get(i));
            }
        }
        return summary;
    }

    private LinkedList<Double> getFinalSummary() {
        LinkedList<Quantiles> summary = this.getStreamSummary();
        LinkedList<Double> finalSummary = new LinkedList<Double>();
        for (int i = 0; i < summary.size(); ++i) {
            Float weight = this.computeLevelForEpsilon(summary.get(i).getEpsilon());
            for (int j = 0; j < summary.get(i).getQuantiles().size(); ++j) {
                int k = 0;
                while ((float)k <= weight.floatValue()) {
                    finalSummary.addAll(summary.get(i).getQuantiles());
                    ++k;
                }
            }
        }
        Collections.sort(finalSummary);
        return finalSummary;
    }

    private Float computeLevelForEpsilon(Float epsilon) {
        Double argument = (double)(2.0f * epsilon.floatValue() * (float)(2 * this.maxLevel + 2)) / this.epsilon;
        Double level = (double)this.maxLevel - Math.log(argument) / Math.log(2.0);
        return Float.valueOf(level.floatValue());
    }

    private void slideWindow() {
        for (int i = 0; i < this.maxLevel + 1; ++i) {
            this.quantiles.get(i).slideWindowByOnePosition();
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.getClass().getCanonicalName());
        s.append(" {");
        s.append(" epsilon=" + this.epsilon);
        s.append(" }");
        return s.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Quantiles
    implements Serializable {
        private static final long serialVersionUID = -6060440214958903531L;
        private Float epsilon;
        private LinkedList<Double> quantiles = new LinkedList();

        public Quantiles(Float epsilon, LinkedList<Double> quantiles) {
            this.epsilon = epsilon;
            this.quantiles = quantiles;
        }

        public Double getQuantile(float phi) {
            int position = Math.round(phi * (float)this.quantiles.size());
            return this.quantiles.get(position);
        }

        public LinkedList<Double> getQuantiles() {
            return this.quantiles;
        }

        public Float getEpsilon() {
            return this.epsilon;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Block
    implements Serializable {
        private static final long serialVersionUID = 7802824333706107860L;
        private Float epsilon;
        private Integer blockSize;
        private LinkedList<Double> summaryOfLastBlock;
        private GKQuantiles quantileEstimator;

        public Block(Float epsilon, Integer blockSize) {
            this.epsilon = epsilon;
            this.blockSize = blockSize;
            this.quantileEstimator = new GKQuantiles(epsilon.floatValue());
            this.summaryOfLastBlock = new LinkedList();
        }

        public void insert(Double item) {
            this.quantileEstimator.offer(item);
            if (this.quantileEstimator.getCount() == this.blockSize) {
                this.createSummary();
                this.quantileEstimator = new GKQuantiles(this.epsilon.floatValue());
            }
        }

        public Integer getBlockSize() {
            return this.blockSize;
        }

        public LinkedList<Double> getSummary() {
            return this.summaryOfLastBlock;
        }

        public Float getEpsilon() {
            return this.epsilon;
        }

        private void createSummary() {
            Float phi = this.epsilon;
            LinkedList<Double> summary = new LinkedList<Double>();
            while (phi.floatValue() <= 1.0f) {
                summary.add(this.quantileEstimator.getQuantile(phi.floatValue()));
                phi = Float.valueOf(phi.floatValue() + this.epsilon.floatValue());
            }
            this.summaryOfLastBlock = summary;
        }
    }
}

