/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.quantile.rss;

import java.io.Serializable;
import java.util.LinkedList;
import org.streaminer.stream.quantile.ExactQuantiles;
import org.streaminer.stream.quantile.QuantilesException;
import org.streaminer.stream.quantile.rss.Interval;
import org.streaminer.stream.quantile.rss.RSSQuantiles;
import org.streaminer.stream.quantile.rss.SubsetTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bucket
implements Serializable {
    private static final long serialVersionUID = 1L;
    double epsilon = 0.0;
    double delta = 0.0;
    int elementCount = 0;
    int maxValue;
    int subsetCount = 0;
    int elementsInGroupCount = 0;
    int groupCount = 0;
    SubsetTree[] subsetTrees;

    public Bucket(float epsilon, float delta, int maxValue) {
        this.delta = delta;
        this.epsilon = epsilon;
        this.maxValue = maxValue;
        this.calculateSubsetCount();
        this.createNewSubsets();
    }

    void createNewSubsets() {
        this.subsetTrees = new SubsetTree[this.subsetCount];
        for (int i = 0; i < this.subsetCount; ++i) {
            this.subsetTrees[i] = new SubsetTree((float)this.epsilon, (float)this.delta, this.maxValue);
        }
    }

    public void process(double item) {
        ++this.elementCount;
        for (SubsetTree subsetTree : this.subsetTrees) {
            subsetTree.addElement(item);
        }
    }

    void calculateSubsetCount() {
        double logU = Bucket.log2(this.maxValue);
        double term1 = 3.0 * Bucket.log2(logU / this.delta);
        double term2 = 8.0 * logU / (this.epsilon * this.epsilon);
        this.elementsInGroupCount = (int)term2 / 100;
        this.groupCount = (int)term1;
        this.subsetCount = this.groupCount * this.elementsInGroupCount;
    }

    public Double estimateIntervals(LinkedList<Interval> intervals) throws QuantilesException {
        int subsetTreeIndex = 0;
        ExactQuantiles exactQuantiles = new ExactQuantiles();
        for (int g = 0; g < this.groupCount; ++g) {
            double groupAverage = 0.0;
            for (int e = 0; e < this.elementsInGroupCount; ++e) {
                double groupEstimation = 0.0;
                for (Interval interval : intervals) {
                    double elementEstimation = this.subsetTrees[subsetTreeIndex].estimateIntervall(interval);
                    if (elementEstimation == -1.0) continue;
                    groupEstimation += elementEstimation;
                }
                groupAverage += groupEstimation;
                if (++subsetTreeIndex <= this.subsetTrees.length) continue;
                System.out.println(this.subsetTrees.length + " index = " + subsetTreeIndex + " count " + this.subsetCount);
            }
            exactQuantiles.offer(groupAverage /= (double)this.elementsInGroupCount);
        }
        return exactQuantiles.getQuantile(0.5);
    }

    public boolean IsFull() {
        return this.elementCount >= RSSQuantiles.ELEMENTS_PER_BUCKET;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public static double log2(double number) {
        return Math.log10(number) / Math.log10(2.0);
    }
}

