/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.quantile.rss;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.streaminer.stream.quantile.IQuantiles;
import org.streaminer.stream.quantile.QuantilesException;
import org.streaminer.stream.quantile.rss.Bucket;
import org.streaminer.stream.quantile.rss.Interval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSSQuantiles
implements IQuantiles<Double>,
Serializable {
    private static final long serialVersionUID = -7491178942147615981L;
    public static final int CANT_ESTIMATE = -1;
    public static int ELEMENTS_PER_BUCKET = 200;
    private static int MAX_BUCKET_COUNT = 5;
    private int maxValue;
    private List<Bucket> buckets;
    private Bucket newestBucket = null;
    private float epsilon;
    private float delta;

    public RSSQuantiles(float epsilon, float delta, int maxValue) {
        this.epsilon = epsilon;
        this.delta = delta;
        this.maxValue = maxValue;
        this.buckets = new CopyOnWriteArrayList<Bucket>();
        this.addNewBucket();
    }

    @Override
    public void offer(Double value) {
        this.newestBucket.process(Math.ceil(value));
        if (this.newestBucket.IsFull()) {
            this.addNewBucket();
        }
        this.deleteExcessiveBuckets();
    }

    @Override
    public Double getQuantile(double q) throws QuantilesException {
        int overallBucketCount = this.overallBucketCount();
        int wantedRank = (int)((float)overallBucketCount * (float)q - (float)overallBucketCount * this.epsilon);
        for (int i = 0; i < this.maxValue; ++i) {
            LinkedList<Interval> intervals = this.collectNeededIntervalls(i);
            double intervalSum = 0.0;
            for (Bucket bucket : new LinkedList<Bucket>(this.buckets)) {
                intervalSum += Math.abs(bucket.estimateIntervals(intervals));
            }
            if (!(intervalSum > (double)wantedRank)) continue;
            return i;
        }
        return -1.0;
    }

    private LinkedList<Interval> collectNeededIntervalls(int rank) {
        LinkedList<Interval> intervals = new LinkedList<Interval>();
        int log2 = 0;
        int chunk = 0;
        int lowerBound = 0;
        int upperBound = 0;
        if (rank == 0) {
            intervals.add(new Interval(0, 0));
        } else {
            ++rank;
            while (rank > 0) {
                log2 = (int)(Math.log10(rank) / Math.log10(2.0));
                chunk = (int)Math.pow(2.0, log2);
                upperBound = lowerBound + chunk - 1;
                intervals.add(new Interval(lowerBound, upperBound));
                lowerBound = upperBound + 1;
                rank -= chunk;
            }
        }
        return intervals;
    }

    private int overallBucketCount() {
        int count = 0;
        for (Bucket bucket : this.buckets) {
            count += bucket.getElementCount();
        }
        return count;
    }

    private void addNewBucket() {
        Bucket newBucket = new Bucket(this.epsilon, this.delta, this.maxValue);
        this.buckets.add(newBucket);
        this.newestBucket = newBucket;
    }

    private void deleteExcessiveBuckets() {
        while (this.buckets.size() > MAX_BUCKET_COUNT) {
            this.buckets.remove(0);
        }
    }

    public void setElementsPerBucket(int newCount) {
        ELEMENTS_PER_BUCKET = newCount;
    }

    public int getElementsPerBucket() {
        return ELEMENTS_PER_BUCKET;
    }

    public void setMaxBucketCount(int newCount) {
        MAX_BUCKET_COUNT = newCount;
        this.deleteExcessiveBuckets();
    }

    public int getMaxBucketCount() {
        return MAX_BUCKET_COUNT;
    }
}

