/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.quantile.rss;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Random;

public class Subset
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int valuesInSubsetCount = 0;
    private int level = 0;
    int intervallWidth = 0;
    int intervalCount = 0;
    int maxValue = 0;
    BitSet intervallBitVector = new BitSet();

    public Subset(int level, int maxValue) {
        this.level = level;
        this.intervallWidth = (int)Math.pow(2.0, level);
        this.maxValue = maxValue;
        int logOfValue = (int)(Math.log10(maxValue) / Math.log10(2.0)) + 1;
        while (!this.selectSubsets((int)Math.pow(2.0, logOfValue))) {
        }
    }

    boolean selectSubsets(int newMaxValue) {
        int lowerBound = 0;
        Random random = new Random();
        boolean bIntervalselected = false;
        this.intervalCount = (int)((double)(newMaxValue - lowerBound) / (double)this.intervallWidth);
        for (int i = 0; i < this.intervalCount; ++i) {
            double event = random.nextDouble();
            if (event >= 0.5) {
                this.intervallBitVector.set(i);
                bIntervalselected = true;
            }
            lowerBound += this.intervallWidth;
        }
        return bIntervalselected;
    }

    public void addElement(double value) {
        int lowerBound = 0;
        int upperBound = Math.max(this.intervallWidth, 1);
        for (int i = 0; i < this.intervalCount; ++i) {
            if (this.intervallBitVector.get(i) && value >= (double)lowerBound && value <= (double)(upperBound - 1)) {
                ++this.valuesInSubsetCount;
                return;
            }
            lowerBound += this.intervallWidth;
            upperBound += this.intervallWidth;
        }
    }

    public String toString() {
        String output = "Subset level = " + this.level + " valuesInSubsetCount = " + this.valuesInSubsetCount + " intervall width " + this.intervallWidth + "\n intervalls:\n ";
        int count = 0;
        int lowerBound = 0;
        int upperBound = Math.max(this.intervallWidth, 1);
        for (int i = 0; i < this.intervalCount; ++i) {
            if (this.intervallBitVector.get(i)) {
                output = output + lowerBound + " - " + (upperBound - 1) + "\n";
                ++count;
            }
            lowerBound += this.intervallWidth;
            upperBound += this.intervallWidth;
        }
        return output + " count = " + count;
    }

    public boolean canHandleInterval(int lowerBound, int upperBound) {
        int lower = 0;
        int upper = Math.max(this.intervallWidth, 1);
        for (int i = 0; i < this.intervalCount; ++i) {
            if (this.intervallBitVector.get(i) && lower == lowerBound && upper - 1 == upperBound) {
                return true;
            }
            lower += this.intervallWidth;
            upper += this.intervallWidth;
        }
        return false;
    }

    public int getValuesInSubsetCount() {
        return this.valuesInSubsetCount;
    }

    public int getIntercalWidth() {
        return this.intervallWidth;
    }
}

