/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.quantile.rss;

import java.io.Serializable;
import org.streaminer.stream.quantile.rss.Interval;
import org.streaminer.stream.quantile.rss.Subset;

public class SubsetTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Subset[] levels;
    float epsilon = 0.0f;
    float delta = 0.0f;
    int maxValue = 0;
    int elementCount = 0;

    public SubsetTree(float epsilon, float delta, int maxValue) {
        this.delta = delta;
        this.epsilon = epsilon;
        this.maxValue = maxValue;
        this.createLevels();
    }

    private void createLevels() {
        int logOfValue = (int)(Math.log10(this.maxValue) / Math.log10(2.0));
        this.levels = new Subset[logOfValue + 2];
        for (int i = 0; i <= logOfValue + 1; ++i) {
            this.levels[i] = new Subset(i, this.maxValue);
        }
    }

    public void addElement(double value) {
        ++this.elementCount;
        for (Subset level : this.levels) {
            level.addElement(value);
        }
    }

    public String toString() {
        String output = "";
        for (Subset level : this.levels) {
            output = output + level;
        }
        return output;
    }

    public Double estimateIntervall(Interval interval) {
        int intervalWidth = interval.getUpperBound() - interval.getLowerBound() + 1;
        for (Subset level : this.levels) {
            if (intervalWidth != level.getIntercalWidth() || !level.canHandleInterval(interval.getLowerBound(), interval.getUpperBound())) continue;
            int valueCount = level.getValuesInSubsetCount();
            return 2.0 * (double)valueCount - (double)this.elementCount;
        }
        return -1.0;
    }
}

