/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.sampler;

import java.util.Random;
import org.streaminer.stream.sampler.ISampler;

public class BernoulliSampler
implements ISampler {
    private final double percent;
    private final Random rnd;
    private Double nextRnd = null;

    public BernoulliSampler(double percent) {
        this.percent = percent / 100.0;
        this.rnd = new Random();
    }

    public BernoulliSampler(double percent, Random rnd) {
        this.percent = percent;
        this.rnd = rnd;
        this.stage();
    }

    public boolean next() {
        boolean val = this.check();
        this.stage();
        return val;
    }

    private boolean check() {
        return this.nextRnd < this.percent;
    }

    private void stage() {
        this.nextRnd = this.rnd.nextDouble();
    }

    public void setSeed(long seed) {
        this.rnd.setSeed(seed);
    }
}

