/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.sampler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streaminer.stream.sampler.ISampleList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainSampler
implements ISampleList<Serializable> {
    private static final Logger LOG = LoggerFactory.getLogger(ChainSampler.class);
    private int k;
    private int n;
    private long count = 0L;
    private int fillSample = 0;
    private Serializable[] items;
    private Map<Integer, Integer> replacements;
    private Random rand = new Random();

    public ChainSampler(int k, int n) {
        this.k = k;
        this.n = n;
        this.items = new Serializable[k];
        this.replacements = new HashMap<Integer, Integer>(k);
    }

    @Override
    public void sample(Serializable item) {
        int i = (int)(this.count % (long)this.n);
        if (this.replacements.containsKey(i)) {
            int replace = this.replacements.get(i);
            this.items[replace] = item;
            int next = this.rand.nextInt(this.n);
            LOG.info(String.format("Item=%s; i=%d; b=%d; next=%d", item, i, replace, next));
            this.replacements.remove(i);
            this.replacements.put(next, replace);
        } else if (this.fillSample < this.k) {
            double prob = (double)Math.min(i, this.n) / (double)this.n;
            if (this.rand.nextDouble() < prob) {
                int bucket = this.fillSample++;
                int next = this.rand.nextInt(this.n);
                this.items[bucket] = item;
                this.replacements.put(next, bucket);
                LOG.info(String.format("[init] Item=%s; i=%d; b=%d; next=%d", item, i, bucket, next));
            }
        }
        ++this.count;
    }

    @Override
    public void sample(Serializable ... t) {
        for (Serializable item : t) {
            this.sample(item);
        }
    }

    @Override
    public Collection<Serializable> getSamples() {
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        for (Serializable item : this.items) {
            if (item == null) continue;
            result.add(item);
        }
        return result;
    }

    @Override
    public int getSize() {
        return this.fillSample < this.k ? this.fillSample : this.k;
    }
}

